/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.composites;

import com.excentis.products.byteblower.gui.wizards.composites.Layer2Composite;
import com.excentis.products.byteblower.gui.wizards.composites.Layer3Composite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PortConfiguration
extends Composite {
    private Layer2Composite l2 = null;
    private Layer3Composite l3 = null;
    private GridData l2Layout = null;
    private GridData l3Layout = null;
    private String errorMessage;

    public PortConfiguration(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                PortConfiguration.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                PortConfiguration.this.onDispose();
            }
        });
    }

    private void initialize() {
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 1;
        localGridlayout.marginWidth = 0;
        localGridlayout.marginHeight = 0;
        localGridlayout.horizontalSpacing = 0;
        localGridlayout.verticalSpacing = 0;
        localGridlayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)localGridlayout);
        this.l2Layout = new GridData(4, 128, false, false);
        this.l3Layout = new GridData(4, 4, false, true);
        this.l2 = new Layer2Composite(this, 0);
        this.l2.setLayoutData(this.l2Layout);
        this.l3 = new Layer3Composite(this, 0);
        this.l3.setLayoutData(this.l3Layout);
    }

    private void onDispose() {
        this.l2.dispose();
        this.l3.dispose();
    }

    private void onResize() {
        this.layout();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.layout();
        }
        super.setVisible(visible);
    }

    public void addModifyListener(ModifyListener listener) {
        this.l2.addModifyListener(listener);
        this.l3.addModifyListener(listener);
    }

    public boolean isComplete() {
        if (this.l2.isComplete()) {
            if (this.l3.isComplete()) {
                return true;
            }
            this.errorMessage = this.l3.getErrorMessage();
            return false;
        }
        this.errorMessage = this.l2.getErrorMessage();
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

