/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize;

import com.excentis.products.byteblower.gui.wizards.topology.PortDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyFlow;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import com.excentis.products.byteblower.gui.wizards.topology.layout.CroppedTreeLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class FrameSizeWizTopology
extends Composite {
    private Canvas canvas = null;
    private GridData canvasData = null;
    private LightweightSystem lws = null;
    private Figure contents = null;
    private PortDevice sourcePortTopologyDevice = null;
    private List<PortDevice> destinationPortTopologyDevices = new ArrayList<PortDevice>();
    private final int maxNumberOfPorts = 20;
    private TopologyLayout topologyLayout = null;
    private boolean changes = false;
    private boolean showFlows = false;
    private boolean bidirectional = false;

    FrameSizeWizTopology(Composite parent, int style) {
        super(parent, style);
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 1;
        localGridlayout.marginWidth = 0;
        localGridlayout.marginHeight = 0;
        localGridlayout.horizontalSpacing = 0;
        localGridlayout.verticalSpacing = 0;
        localGridlayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)localGridlayout);
        this.canvas = new Canvas((Composite)this, 0);
        this.canvasData = new GridData(1808);
        this.canvas.setLayoutData((Object)this.canvasData);
        this.canvas.setBackground(ColorConstants.white);
        this.lws = new LightweightSystem(this.canvas);
        this.contents = new Figure();
        XYLayout contentsLayout = new XYLayout();
        this.contents.setLayoutManager((LayoutManager)contentsLayout);
        this.topologyLayout = new CroppedTreeLayout(this.contents);
        this.sourcePortTopologyDevice = new PortDevice();
        this.sourcePortTopologyDevice.setLayoutManager(this.topologyLayout);
        PortDevice oneDefaultDestinationPort = new PortDevice();
        oneDefaultDestinationPort.setLayoutManager(this.topologyLayout);
        this.sourcePortTopologyDevice.addChild(oneDefaultDestinationPort);
        this.destinationPortTopologyDevices.add(oneDefaultDestinationPort);
        this.lws.setContents((IFigure)this.contents);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = FrameSizeWizTopology.this.getBounds();
                FrameSizeWizTopology.this.canvasData.widthHint = bounds.width;
                FrameSizeWizTopology.this.canvasData.heightHint = bounds.height;
                FrameSizeWizTopology.this.layout();
                FrameSizeWizTopology.this.Redraw();
            }
        });
    }

    private void Redraw() {
        this.topologyLayout.Update(false);
    }

    public void applyChanges(boolean animate) {
        if (this.changes) {
            this.topologyLayout.Update(animate);
        }
        this.changes = false;
    }

    public void setFocusOnPort(boolean source) {
        if (source) {
            this.sourcePortTopologyDevice.Focus();
        } else {
            for (PortDevice portDevice : this.destinationPortTopologyDevices) {
                portDevice.Focus();
            }
        }
    }

    void showFlows() {
        this.sourcePortTopologyDevice.addFlow(this.destinationPortTopologyDevices.get(0));
        this.showFlows = true;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
        if (!this.showFlows) {
            return;
        }
        int nofPorts = this.destinationPortTopologyDevices.size();
        int i = 0;
        while (i < nofPorts) {
            PortDevice destDevice = this.destinationPortTopologyDevices.get(i);
            if (bidirectional) {
                TopologyFlow flowBack = destDevice.addFlow(this.sourcePortTopologyDevice);
                flowBack.setLayoutManager(this.topologyLayout);
            } else {
                TopologyFlow flow = destDevice.removeFlow(this.sourcePortTopologyDevice);
                if (flow != null) {
                    this.topologyLayout.Remove(flow);
                }
            }
            ++i;
        }
        this.changes = true;
    }

    public void setNofDestinations(int newNumberOfPorts) {
        int nofPorts;
        if (newNumberOfPorts > 20) {
            newNumberOfPorts = 20;
        }
        int i = nofPorts = this.destinationPortTopologyDevices.size();
        while (i < newNumberOfPorts) {
            PortDevice newPort = new PortDevice();
            newPort.setLayoutManager(this.topologyLayout);
            this.sourcePortTopologyDevice.addChild(newPort);
            newPort.setLocation(new Point(this.contents.getBounds().width / 2, this.contents.getBounds().height));
            this.destinationPortTopologyDevices.add(newPort);
            if (this.showFlows) {
                this.sourcePortTopologyDevice.addFlow(newPort);
                if (this.bidirectional) {
                    newPort.addFlow(this.sourcePortTopologyDevice);
                }
            }
            ++i;
        }
        i = nofPorts - 1;
        while (i >= newNumberOfPorts) {
            PortDevice victim = this.destinationPortTopologyDevices.get(i);
            if (this.showFlows) {
                TopologyFlow flow = this.sourcePortTopologyDevice.getFlowTo(victim);
                if (flow != null) {
                    this.topologyLayout.Remove(flow);
                }
                if (this.bidirectional && (flow = victim.removeFlow(this.sourcePortTopologyDevice)) != null) {
                    this.topologyLayout.Remove(flow);
                }
            }
            this.sourcePortTopologyDevice.removeChild(victim);
            this.destinationPortTopologyDevices.remove((Object)victim);
            --i;
        }
        this.changes = true;
    }
}

