/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard;

import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.composites.PortConfiguration;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.FullMeshWizard;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.Messages;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites.TopologyOverview;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

class AddressConfigurationPage
extends WizardPage {
    private TopologyOverview topology = null;
    private PortConfiguration portConfiguration = null;
    private Composite container = null;
    private int portNumber;

    AddressConfigurationPage(int number) {
        super("AddressConfigurationPage." + number);
        this.setTitle(Messages.getString("AddressConfigurationPage.Title"));
        this.setDescription(String.valueOf(Messages.getString("AddressConfigurationPage.Description")) + number);
        this.portNumber = number;
    }

    @Override
    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        this.container.setLayout((Layout)fillLayout);
        this.setControl((Control)this.container);
        this.topology = new TopologyOverview(this.container, 2048);
        this.portConfiguration = new PortConfiguration(this.container, 0);
        this.setPageComplete(false);
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AddressConfigurationPage.this.onResize();
            }
        });
        this.portConfiguration.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddressConfigurationPage.this.onChange();
            }
        });
        this.onChange();
    }

    private void onResize() {
        this.container.layout();
        System.out.println(String.valueOf(this.getShell().getSize().x) + "  " + this.getShell().getSize().y);
    }

    private void onChange() {
        if (this.portConfiguration.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(this.portConfiguration.getErrorMessage());
            this.setPageComplete(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.topology.setNumberOfPorts(((FullMeshWizard)this.getWizard()).getNumberOfPorts());
            this.portConfiguration.layout();
            this.topology.setFocusOnPort(this.portNumber - 1);
            this.topology.applyChanges();
        }
        super.setVisible(visible);
    }
}

