/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard;

import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.FullMeshWizard;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.Messages;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites.TopologyManipulator;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites.TopologyOverview;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class TopologyConfigurationPage
extends WizardPage {
    private TopologyOverview topology;
    private static final int maxNofPorts = 40;
    private TopologyManipulator manipulator;

    public TopologyConfigurationPage() {
        super("DevicePage");
        this.setTitle(Messages.getString("TopologyConfigurationPage.Title"));
        this.setDescription(Messages.getString("TopologyConfigurationPage.Description"));
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new TopologyOverview(container, 2048);
        this.manipulator = new TopologyManipulator(container);
        this.setPageComplete(false);
        this.manipulator.setFocus();
        this.manipulator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TopologyConfigurationPage.this.onChanges();
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
    }

    private void onChanges() {
        boolean pageComplete = false;
        String errorMessage = null;
        if (this.manipulator.isValidPortNumber()) {
            int nofPorts = this.manipulator.getNumberOfPorts();
            if (nofPorts <= 40) {
                this.topology.setNumberOfPorts(nofPorts);
                ((FullMeshWizard)this.getWizard()).setNumberOfPorts(nofPorts);
                pageComplete = true;
            } else {
                errorMessage = String.valueOf(Messages.getString("TopologyConfigurationPage.tooBigNumberOfPorts")) + 40;
                pageComplete = false;
            }
        } else {
            this.setMessage(null);
            errorMessage = Messages.getString("TopologyConfigurationPage.invalidNumberOfPorts");
            pageComplete = false;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(pageComplete);
        this.topology.applyChanges();
    }
}

