/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites;

import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.composites.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TopologyManipulator
extends Composite {
    private Label introLabel = null;
    private Label portLabel = null;
    private Text portText = null;
    private Group introGroup = null;
    private Group portGroup = null;

    public TopologyManipulator(Composite parent) {
        super(parent, 0);
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = TopologyManipulator.this.getBounds();
                ((RowData)TopologyManipulator.this.introLabel.getLayoutData()).width = bounds.width - 20;
                ((RowData)TopologyManipulator.this.portLabel.getLayoutData()).width = bounds.width - 20;
                ((RowData)TopologyManipulator.this.introGroup.getLayoutData()).width = bounds.width - 10;
                ((RowData)TopologyManipulator.this.portGroup.getLayoutData()).width = bounds.width - 10;
                ((RowData)TopologyManipulator.this.portText.getLayoutData()).width = bounds.width / 4;
                TopologyManipulator.this.layout();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                TopologyManipulator.this.onDispose();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                TopologyManipulator.this.portText.setFocus();
            }
        });
    }

    private void initialize() {
        RowLayout localLayout = new RowLayout();
        localLayout.type = 512;
        localLayout.fill = true;
        localLayout.justify = false;
        localLayout.marginTop = 0;
        localLayout.marginBottom = 0;
        this.setLayout((Layout)localLayout);
        this.introGroup = new Group((Composite)this, 0);
        this.introGroup.setText(Messages.getString("TopologyManipulator.General"));
        this.introGroup.setLayout((Layout)new RowLayout());
        this.introGroup.setLayoutData((Object)new RowData());
        this.introLabel = new Label((Composite)this.introGroup, 64);
        this.introLabel.setLayoutData((Object)new RowData());
        this.introLabel.setText(Messages.getString("TopologyManipulator.IntroText"));
        this.portGroup = new Group((Composite)this, 0);
        this.portGroup.setText(Messages.getString("TopologyManipulator.Ports"));
        this.portGroup.setLayout((Layout)new RowLayout(512));
        this.portGroup.setLayoutData((Object)new RowData());
        this.portLabel = new Label((Composite)this.portGroup, 64);
        this.portLabel.setLayoutData((Object)new RowData());
        this.portLabel.setText(Messages.getString("TopologyManipulator.NumberOfPorts"));
        this.portText = new Text((Composite)this.portGroup, 2048);
        this.portText.setLayoutData((Object)new RowData());
        this.portText.setTextLimit(2);
        this.portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                event.doit = event.text.length() == 0 || Character.isDigit(event.text.charAt(0));
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.portText.addModifyListener(listener);
    }

    private void onDispose() {
        if (this.portText != null) {
            this.portText.dispose();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public boolean isValidPortNumber() {
        return this.portText.getText().length() != 0;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.portText.setEnabled(enabled);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.portText.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.portText.setToolTipText(string);
    }

    public int getNumberOfPorts() {
        try {
            return new Integer(this.portText.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

