/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.rfc2544;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class TestSelectionPage
extends WizardPage {
    private static final String title = "RFC 2544 Test selection";
    private final AtomicBoolean testThroughput = new AtomicBoolean(true);
    private final AtomicBoolean testLatency = new AtomicBoolean(false);
    private final AtomicBoolean testFrameLoss = new AtomicBoolean(false);
    private final AtomicBoolean testBackToBack = new AtomicBoolean(false);

    public TestSelectionPage() {
        super(title);
        this.setTitle(title);
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/framesizewizard.gif"));
    }

    private void createTestbox(CheckBoxListener listen, Composite container, AtomicBoolean testPart, String shortTxt, String longTxt) {
        Button testSelection = new Button(container, 32);
        testSelection.addSelectionListener((SelectionListener)new CheckBoxListener());
        testSelection.setText(shortTxt);
        boolean enable = testPart.get();
        testSelection.setSelection(enable);
        testSelection.setEnabled(enable);
        testSelection.setAlignment(4);
        listen.addCheckBox(testSelection, testPart);
        testSelection.setLayoutData((Object)new GridData(16384, 128, true, false));
        Label descriptionLabel = new Label(container, 128);
        String throughput_description = WordUtils.wrap((String)(String.valueOf(longTxt) + "\n"), (int)80);
        descriptionLabel.setText(throughput_description);
        descriptionLabel.setEnabled(enable);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 128, true, true));
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        CheckBoxListener listener = new CheckBoxListener();
        this.createTestbox(listener, container, this.testThroughput, "Throughput test", "Finds the maximum framerate of the device.");
        this.createTestbox(listener, container, this.testFrameLoss, "Frame loss rate", "Tests the devices at fixed framerates intervals.");
        this.createTestbox(listener, container, this.testLatency, "Latency test", "Measures how much a frame is delayed at the maximum framerate.");
        this.createTestbox(listener, container, this.testBackToBack, "Back-to-back frames", "Searches for the longest burst of frames at the linerate.");
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
    }

    public boolean isThroughputEnabled() {
        return this.testThroughput.get();
    }

    public boolean isFrameLossEnabled() {
        return this.testFrameLoss.get();
    }

    public boolean isLatencyEnabled() {
        return this.testLatency.get();
    }

    public boolean isBacktoBackEnabled() {
        return this.testBackToBack.get();
    }

    private static class CheckBoxListener
    implements SelectionListener {
        private Map<Button, AtomicBoolean> connections = new HashMap<Button, AtomicBoolean>();

        private CheckBoxListener() {
        }

        private void handleInput(SelectionEvent e) {
            Object source = e.getSource();
            AtomicBoolean res = this.connections.get(e.getSource());
            if (res != null) {
                res.set(((Button)source).getSelection());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleInput(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleInput(e);
        }

        public void addCheckBox(Button check, AtomicBoolean target) {
            this.connections.put(check, target);
            check.addSelectionListener((SelectionListener)this);
        }
    }
}

