/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.DoubleTextFactory;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigDecimal;
import java.util.Calendar;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SpeedIncrementComposite
extends Composite
implements ModifyListener,
SelectionListener {
    private FrameBlastingFlowController frameBlastingFlowController;
    private String errorMessage;
    private static final int frameRateScale = 11;
    private Text textFrameInterval;
    private Text textFrameRate;
    private Text textThroughput;
    private Combo comboThroughputUnit;
    private Button btnDecrementFrameInterval;
    private Button btnIncrementFrameRate;
    private Button btnIncrementThroughput;
    private String throughput;

    public SpeedIncrementComposite(Composite parent, int style, FrameBlastingFlowController frameBlastingFlowController) {
        super(parent, style);
        this.frameBlastingFlowController = frameBlastingFlowController;
        this.initialize();
    }

    private void enableControls() {
        this.textFrameInterval.setEnabled(this.btnDecrementFrameInterval.getSelection());
        this.textFrameRate.setEnabled(this.btnIncrementFrameRate.getSelection());
        this.textThroughput.setEnabled(this.btnIncrementThroughput.getSelection());
        this.comboThroughputUnit.setEnabled(this.btnIncrementThroughput.getSelection());
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.btnDecrementFrameInterval = new Button((Composite)this, 16);
        this.btnDecrementFrameInterval.setText("Decrement Frame Interval:");
        this.textFrameInterval = TimeTextFactory.instance().create((Composite)this, 2048);
        this.textFrameInterval.addModifyListener((ModifyListener)this);
        Label label = new Label((Composite)this, 0);
        label.setText("time");
        this.btnDecrementFrameInterval.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpeedIncrementComposite.this.enableControls();
                SpeedIncrementComposite.this.updateFrameInterval();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textFrameInterval.setLayoutData((Object)new GridData(768));
        this.textFrameInterval.setEnabled(false);
        this.btnIncrementFrameRate = new Button((Composite)this, 16);
        this.btnIncrementFrameRate.setText("Increment Frame Rate:");
        this.textFrameRate = DoubleTextFactory.instance().create((Composite)this, 2048, 11);
        this.textFrameRate.setTextLimit(20);
        this.textFrameRate.addModifyListener((ModifyListener)this);
        label = new Label((Composite)this, 0);
        label.setText("Frames/s");
        this.btnIncrementFrameRate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpeedIncrementComposite.this.enableControls();
                SpeedIncrementComposite.this.updateFrameRate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textFrameRate.setLayoutData((Object)new GridData(768));
        this.textFrameRate.addModifyListener((ModifyListener)this);
        this.btnIncrementFrameRate.setSelection(true);
        this.btnIncrementThroughput = new Button((Composite)this, 16);
        this.btnIncrementThroughput.setText("Increment Intended Load:");
        this.textThroughput = DoubleTextFactory.instance().create((Composite)this, 2048, 11);
        this.textThroughput.addModifyListener((ModifyListener)this);
        this.textThroughput.setEnabled(false);
        this.btnIncrementThroughput.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpeedIncrementComposite.this.enableControls();
                SpeedIncrementComposite.this.updateThroughput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textThroughput.setLayoutData((Object)new GridData(768));
        this.textThroughput.addModifyListener((ModifyListener)this);
        this.comboThroughputUnit = new Combo((Composite)this, 76);
        DataRateUnit[] dataRateUnitArray = DataRateUnit.values();
        int n = dataRateUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataRateUnit dataRateUnit = dataRateUnitArray[n2];
            this.comboThroughputUnit.add(dataRateUnit.getName());
            ++n2;
        }
        this.comboThroughputUnit.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        this.enableControls();
    }

    private void updateThroughput() {
        BigDecimal value;
        String txt = this.textThroughput.getText();
        if (txt.length() == 0 || txt.equals(this.throughput)) {
            return;
        }
        this.throughput = txt;
        try {
            value = new BigDecimal(this.throughput);
        }
        catch (Exception exception) {
            System.out.println("Invalid argument for setThroughput method : " + this.throughput);
            return;
        }
        ThroughputType type = this.getThroughputType();
        Command command = this.frameBlastingFlowController.setThroughput(value, type);
        if (command == null) {
            this.textThroughput.setForeground(ExcentisColors.red);
        } else {
            this.textThroughput.setForeground(null);
            command.execute();
        }
    }

    private ThroughputType getThroughputType() {
        return this.getProject().getThroughputType();
    }

    private ByteBlowerProject getProject() {
        return ByteBlowerGuiResourceController.getInstance().getActiveProject();
    }

    private void initializeValues() {
        this.textFrameInterval.setText("1ms");
        this.textFrameRate.setText("100");
        this.textThroughput.setText("100");
        this.comboThroughputUnit.select(1);
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (!control.isFocusControl()) {
            return;
        }
        if (control == this.textFrameInterval) {
            this.updateFrameInterval();
        } else if (control == this.textFrameRate) {
            this.updateFrameRate();
        } else if (control == this.textThroughput) {
            this.updateThroughput();
        }
    }

    private void updateFrameRate() {
        String frameRate = this.textFrameRate.getText();
        if (frameRate.length() == 0) {
            return;
        }
        Command command = this.frameBlastingFlowController.setFrameRate(new BigDecimal(frameRate));
        if (command != null) {
            command.execute();
        }
    }

    private void updateFrameInterval() {
        String frameInterval = this.textFrameInterval.getText();
        if (frameInterval.length() == 0) {
            return;
        }
        HighResolutionCalendar interval = new HighResolutionCalendar();
        HighResolutionCalendarParser.setRelativeTime((String)frameInterval, (HighResolutionCalendar)interval);
        Command command = this.frameBlastingFlowController.setFrameInterval(interval);
        if (command != null) {
            command.execute();
        }
    }

    public boolean isComplete() {
        this.textFrameInterval.setForeground(null);
        this.textFrameRate.setForeground(null);
        HighResolutionCalendar minAllowedDecr = new HighResolutionCalendar(Long.valueOf(1L));
        BigDecimal minAllowedRate = new BigDecimal(1.0E-11);
        boolean tooSmall = false;
        if (this.getIsIncrementFrameRate()) {
            try {
                BigDecimal incrFrameRate = new BigDecimal(this.getFrameRate());
                if (incrFrameRate.compareTo(minAllowedRate) < 0) {
                    tooSmall = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                tooSmall = true;
            }
            if (tooSmall) {
                this.textFrameRate.setForeground(ColorConstants.red);
                this.errorMessage = "The Minimum Increment Frame Rate is 0.00000000001 Frames/s.";
                return false;
            }
        } else {
            try {
                HighResolutionCalendar decrFrameInterval = this.getFrameInterval();
                if (decrFrameInterval.compareTo((Calendar)minAllowedDecr) < 0) {
                    tooSmall = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                tooSmall = true;
            }
            if (tooSmall) {
                this.textFrameInterval.setForeground(ColorConstants.red);
                String strMinRate = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)minAllowedDecr, (boolean)false, (boolean)true);
                this.errorMessage = "The Minimum Decrement Frame Interval is " + strMinRate + ".";
                return false;
            }
        }
        return true;
    }

    void addModifyListener(ModifyListener listener) {
        this.textFrameInterval.addModifyListener(listener);
        this.textFrameRate.addModifyListener(listener);
        this.textThroughput.addModifyListener(listener);
    }

    public HighResolutionCalendar getFrameInterval() {
        HighResolutionCalendar interval = new HighResolutionCalendar();
        String strInterval = this.textFrameInterval.getText();
        HighResolutionCalendarParser.setRelativeTime((String)strInterval, (HighResolutionCalendar)interval);
        return interval;
    }

    public String getFrameRate() {
        return this.textFrameRate.getText();
    }

    public String getThroughput() {
        return this.textThroughput.getText();
    }

    public int getThroughputUnit() {
        return this.comboThroughputUnit.getSelectionIndex();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    void addSelectionListener(SelectionListener listener) {
        this.btnDecrementFrameInterval.addSelectionListener(listener);
        this.btnIncrementFrameRate.addSelectionListener(listener);
        this.btnIncrementThroughput.addSelectionListener(listener);
        this.comboThroughputUnit.addSelectionListener(listener);
    }

    public ESpeedIncrementType getSpeedIncrementType() {
        if (this.getIsDecrementFrameInterval()) {
            return ESpeedIncrementType.DECREMENT_FRAME_INTERVAL;
        }
        if (this.getIsIncrementFrameRate()) {
            return ESpeedIncrementType.INCREMENT_FRAME_RATE;
        }
        if (this.getIsIncrementThroughput()) {
            return ESpeedIncrementType.INCREMENT_INTENDED_LOAD;
        }
        return null;
    }

    private boolean getIsDecrementFrameInterval() {
        return this.btnDecrementFrameInterval.getSelection();
    }

    private boolean getIsIncrementFrameRate() {
        return this.btnIncrementFrameRate.getSelection();
    }

    private boolean getIsIncrementThroughput() {
        return this.btnIncrementThroughput.getSelection();
    }

    public void setFrameRateColor(Color color) {
        this.textFrameRate.setForeground(color);
    }

    public void setFrameIntervalColor(Color color) {
        this.textFrameInterval.setForeground(color);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public DataRateUnit getDataRateUnit() {
        int index = this.comboThroughputUnit.getSelectionIndex();
        return DataRateUnit.get((int)index);
    }

    public void widgetSelected(SelectionEvent e) {
        Control control = (Control)e.widget;
        if (control == this.comboThroughputUnit) {
            BigDecimal value;
            this.comboThroughputUnit.setFocus();
            String throughput = this.textThroughput.getText();
            try {
                value = new BigDecimal(throughput);
            }
            catch (Exception exception) {
                System.out.println("Invalid argument for setThroughput method : " + throughput);
                return;
            }
            Command command = this.frameBlastingFlowController.setDataRateUnit(this.getDataRateUnit());
            if (command != null) {
                command.execute();
            }
            if ((command = this.frameBlastingFlowController.setThroughput(value, this.getProject().getThroughputType())) != null) {
                command.execute();
            }
        }
    }

    public static enum ESpeedIncrementType {
        DECREMENT_FRAME_INTERVAL,
        INCREMENT_FRAME_RATE,
        INCREMENT_INTENDED_LOAD;

    }
}

