/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.topology;

import com.excentis.products.byteblower.gui.wizards.topology.MoreDecoration;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.swt.graphics.Color;

public class TopologyConnection
extends PolylineConnection {
    private TopologyDevice startDevice;
    private TopologyDevice stopDevice;
    private TopologyLayout layoutManager = null;
    private Color bg;
    private Color fg;

    TopologyConnection(TopologyDevice start, TopologyDevice end) {
        this.startDevice = start;
        this.stopDevice = end;
        this.bg = this.getBackgroundColor();
        this.fg = this.getForegroundColor();
        this.setLineWidth(1);
    }

    public TopologyDevice getChildDevice() {
        return this.stopDevice;
    }

    public TopologyDevice getParentDevice() {
        return this.startDevice;
    }

    protected void remove() {
        this.stopDevice.remove();
        this.layoutManager.Remove(this);
    }

    public void setLayoutManager(TopologyLayout layout) {
        this.layoutManager = layout;
        layout.Add(this);
        this.bg = this.getBackgroundColor();
        this.fg = this.getForegroundColor();
    }

    public void Update() {
        if (this.startDevice.isVisible() && this.stopDevice.isVisible()) {
            this.setSourceDecoration(null);
            this.setForegroundColor(this.fg);
        } else {
            MoreDecoration sourceDecoration = new MoreDecoration();
            MoreDecoration targetDecoration = new MoreDecoration();
            this.setSourceDecoration(sourceDecoration);
            this.setTargetDecoration(targetDecoration);
            this.setForegroundColor(this.bg);
            sourceDecoration.setForegroundColor(this.fg);
            targetDecoration.setForegroundColor(this.fg);
        }
        this.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.startDevice));
        this.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.stopDevice));
    }
}

