/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.topology;

import com.excentis.products.byteblower.gui.wizards.topology.PortDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyConnection;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyFlow;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class TopologyDevice
extends Figure {
    private static Font deviceFont = new Font(null, "Verdana", 10, 0);
    private ImageFigure imageLabel = null;
    private ImageFigure focusFigure = null;
    private Label nameLabel = null;
    private boolean focussed = false;
    private TopologyLayout layoutManager = null;
    private List<TopologyConnection> parentConnections = new ArrayList<TopologyConnection>();
    protected List<TopologyConnection> childConnections = new ArrayList<TopologyConnection>();
    private List<TopologyFlow> destinationFlows = new ArrayList<TopologyFlow>();
    private List<TopologyFlow> sourceFlows = new ArrayList<TopologyFlow>();

    TopologyDevice(String name, ImageData image, ImageData focusImage) {
        this.Initialize();
        this.imageLabel = new ImageFigure(new Image(null, image));
        this.imageLabel.setFont(deviceFont);
        this.focusFigure = new ImageFigure(new Image(null, focusImage));
        this.focusFigure.setBorder((Border)new LineBorder(ColorConstants.red));
        this.focusFigure.setFont(deviceFont);
        this.nameLabel = new Label(name);
        this.nameLabel.setFont(deviceFont);
        this.add((IFigure)this.imageLabel);
        this.add((IFigure)this.nameLabel);
    }

    TopologyDevice(ImageData image, ImageData focusImage) {
        this.Initialize();
        this.imageLabel = new ImageFigure(new Image(null, image));
        this.focusFigure = new ImageFigure(new Image(null, focusImage));
        this.focusFigure.setBorder((Border)new LineBorder(ColorConstants.red));
        this.focusFigure.setFont(deviceFont);
        this.add((IFigure)this.imageLabel);
    }

    public void addChild(TopologyDevice child) {
        TopologyConnection newConnection = new TopologyConnection(this, child);
        this.childConnections.add(newConnection);
        child.parentConnections.add(newConnection);
        child.setLayoutManager(this.layoutManager);
        newConnection.setLayoutManager(this.layoutManager);
    }

    public void setLayoutManager(TopologyLayout layout) {
        this.layoutManager = layout;
        this.layoutManager.Add(this);
    }

    public TopologyFlow addFlow(TopologyDevice destination) {
        TopologyFlow newFlow = new TopologyFlow(this, destination);
        this.sourceFlows.add(newFlow);
        destination.destinationFlows.add(newFlow);
        newFlow.setLayoutManager(this.layoutManager);
        return newFlow;
    }

    public void removeChild(TopologyDevice child) {
        int i = 0;
        while (i < this.childConnections.size()) {
            if (((Object)((Object)this.childConnections.get(i).getChildDevice())).equals((Object)child)) {
                this.childConnections.get(i).getChildDevice().removeParent(this);
                this.childConnections.get(i).remove();
                this.childConnections.remove(i);
                break;
            }
            ++i;
        }
    }

    public TopologyFlow getFlowTo(PortDevice destination) {
        TopologyFlow flow = null;
        for (TopologyFlow tFlow : this.sourceFlows) {
            if (!((Object)((Object)tFlow.getChildDevice())).equals((Object)destination)) continue;
            flow = tFlow;
            break;
        }
        return flow;
    }

    public TopologyFlow removeFlow(TopologyDevice destination) {
        TopologyFlow tFlow2 = null;
        for (TopologyFlow tFlow2 : this.sourceFlows) {
            if (!((Object)((Object)tFlow2.getChildDevice())).equals((Object)destination)) continue;
            this.sourceFlows.remove((Object)tFlow2);
            tFlow2.getChildDevice().destinationFlows.remove((Object)tFlow2);
            break;
        }
        return tFlow2;
    }

    public boolean hasFlow(TopologyDevice destination) {
        for (TopologyFlow tFlow : this.sourceFlows) {
            if (!((Object)((Object)tFlow.getChildDevice())).equals((Object)destination)) continue;
            return true;
        }
        return false;
    }

    private void removeParent(TopologyDevice parentDevice) {
        int i = 0;
        while (i < this.parentConnections.size()) {
            if (((Object)((Object)this.parentConnections.get(i).getParentDevice())).equals((Object)parentDevice)) {
                this.parentConnections.remove(i);
                break;
            }
            ++i;
        }
    }

    private void Initialize() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setVertical(true);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void remove() {
        while (!this.childConnections.isEmpty()) {
            this.removeChild(this.childConnections.get(0).getChildDevice());
        }
        this.layoutManager.Remove(this);
    }

    public List<TopologyConnection> getChildConnections() {
        return this.childConnections;
    }

    public void Focus() {
        if (!this.focussed) {
            try {
                this.remove((IFigure)this.imageLabel);
                if (this.nameLabel != null) {
                    this.remove((IFigure)this.nameLabel);
                }
                this.add((IFigure)this.focusFigure);
                this.focussed = true;
                this.layoutManager.Update(this);
            }
            catch (Exception exception) {}
        }
    }
}

