/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.topology.layout;

import com.excentis.products.byteblower.gui.wizards.topology.TopologyConnection;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyFlow;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

class TreeLayout
extends TopologyLayout {
    static final long DURATION = 230L;
    protected DirectedGraph graph = null;
    protected long current;
    private double progress;
    protected long start = -1L;
    protected long finish;
    protected List<TopologyFlow> flowList = new ArrayList<TopologyFlow>();
    private int verticalSpace = 80;

    TreeLayout(Figure parent) {
        super(parent);
        this.graph = new DirectedGraph();
    }

    @Override
    public void Add(TopologyFlow flow) {
        if (!this.flowList.contains((Object)flow)) {
            this.flowList.add(flow);
            this.parentFigure.add((IFigure)flow);
        }
    }

    @Override
    public void Remove(TopologyFlow flow) {
        if (this.flowList.contains((Object)flow)) {
            this.flowList.remove((Object)flow);
            this.parentFigure.remove((IFigure)flow);
        }
    }

    @Override
    public void Add(TopologyDevice device) {
        if (!this.objectMapper.containsKey((Object)device)) {
            Node node = new Node();
            node.width = device.getPreferredSize().width;
            node.height = device.getPreferredSize().height;
            node.setPadding(new Insets(this.verticalSpace, 0, 0, 0));
            this.objectMapper.put(device, node);
            NodeList nodeList = this.graph.nodes;
            nodeList.add((Object)node);
            this.parentFigure.add((IFigure)device);
        }
    }

    @Override
    public void Add(TopologyConnection connection) {
        if (!this.objectMapper.containsKey((Object)connection)) {
            Node sn = (Node)this.objectMapper.get((Object)connection.getParentDevice());
            Node en = (Node)this.objectMapper.get((Object)connection.getChildDevice());
            Edge e = new Edge(sn, en);
            this.objectMapper.put(connection, e);
            this.graph.edges.add((Object)e);
            this.parentFigure.add((IFigure)connection);
        }
    }

    @Override
    public void Update(boolean animation) {
        new DirectedGraphLayout().visit(this.graph);
        Iterator temp = this.objectMapper.keySet().iterator();
        this.start = System.currentTimeMillis();
        this.finish = this.start + 230L;
        this.current = this.start + 20L;
        if (animation) {
            while (this.step()) {
                this.UpdateLayout();
            }
        }
        this.start = -1L;
        temp = this.objectMapper.keySet().iterator();
        ArrayList edgeList = new ArrayList();
        while (temp.hasNext()) {
            Object element = temp.next();
            try {
                Node n = (Node)this.objectMapper.get(element);
                ((TopologyDevice)((Object)element)).setBounds(new Rectangle(n.x, n.y, n.width, n.height));
            }
            catch (Exception exception) {
                try {
                    edgeList.add(element);
                }
                catch (Exception exception2) {}
            }
        }
        for (TopologyConnection connection : edgeList) {
            connection.Update();
        }
    }

    protected void UpdateLayout() {
        Iterator nodeVisitor = this.objectMapper.keySet().iterator();
        ArrayList edgeList = new ArrayList();
        while (nodeVisitor.hasNext()) {
            Object element = nodeVisitor.next();
            try {
                Node n = (Node)this.objectMapper.get(element);
                TopologyDevice device = (TopologyDevice)((Object)element);
                int newX = device.getBounds().x;
                int newY = device.getBounds().y;
                newX = (int)((long)newX + (long)(n.x - newX) / (this.finish - this.current));
                newY = (int)((long)newY + (long)(n.y - newY) / (this.finish - this.current));
                device.setBounds(new Rectangle(newX, newY, n.width, n.height));
            }
            catch (Exception exception) {
                try {
                    edgeList.add(element);
                }
                catch (Exception exception2) {}
            }
        }
        for (TopologyConnection connection : edgeList) {
            connection.Update();
        }
        for (TopologyFlow flow : this.flowList) {
            flow.Update();
        }
        this.parentFigure.getUpdateManager().performUpdate();
    }

    @Override
    public void Remove(TopologyDevice device) {
        if (this.objectMapper.containsKey((Object)device)) {
            Node victim = (Node)this.objectMapper.get((Object)device);
            this.graph.removeNode(victim);
            this.objectMapper.remove((Object)device);
            this.parentFigure.remove((IFigure)device);
        }
    }

    @Override
    public void Remove(TopologyConnection connection) {
        if (this.objectMapper.containsKey((Object)connection)) {
            Edge victim = (Edge)this.objectMapper.get((Object)connection);
            this.graph.removeEdge(victim);
            this.objectMapper.remove((Object)connection);
            this.parentFigure.remove((IFigure)connection);
        }
    }

    @Override
    public boolean isVisible(TopologyDevice device) {
        return true;
    }

    @Override
    public boolean isVisible(TopologyConnection device) {
        return true;
    }

    protected boolean step() {
        this.current = System.currentTimeMillis() + 30L;
        this.progress = (double)(this.current - this.start) / (double)(this.finish - this.start);
        this.progress = Math.min(this.progress, 0.999);
        return this.current < this.finish;
    }

    @Override
    public void Update(TopologyDevice device) {
        if (this.objectMapper.containsKey((Object)device)) {
            Node n = (Node)this.objectMapper.get((Object)device);
            n.width = device.getPreferredSize().width;
            n.height = device.getPreferredSize().height;
            n.setPadding(new Insets(this.verticalSpace, 0, 0, 0));
        }
    }
}

