/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.composites;

import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigInteger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FlowSizeComposite
extends Composite
implements ModifyListener,
SelectionListener {
    private String errorMessage;
    private Text txtDuration;
    private Text txtNofFrames;
    private Button radioNofFrames;
    private Button radioDuration;
    private FlowSizeType type;

    public FlowSizeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.radioNofFrames = new Button((Composite)this, 16);
        this.radioNofFrames.setText("Number of Frames:");
        this.radioNofFrames.addSelectionListener((SelectionListener)this);
        this.txtNofFrames = IntegerTextFactory.instance().createWithTextLimit((Composite)this, 20);
        this.txtNofFrames.setLayoutData((Object)new GridData(768));
        this.txtNofFrames.addModifyListener((ModifyListener)this);
        this.radioDuration = new Button((Composite)this, 16);
        this.radioDuration.setText("Flow duration:");
        this.radioDuration.addSelectionListener((SelectionListener)this);
        this.txtDuration = TimeTextFactory.instance().create((Composite)this, 2048);
        this.txtDuration.setLayoutData((Object)new GridData(768));
        this.txtDuration.addModifyListener((ModifyListener)this);
        this.initializeValues();
    }

    private void initializeValues() {
        this.radioNofFrames.setSelection(true);
        this.update();
        this.type = FlowSizeType.NOF_FRAMES;
        this.txtNofFrames.setText("1000");
        this.txtDuration.setText("10s");
        this.updateWidgets();
    }

    public void modifyText(ModifyEvent e) {
        Control cfr_ignored_0 = (Control)e.widget;
    }

    public boolean isComplete() {
        return true;
    }

    public HighResolutionCalendar getDuration() {
        HighResolutionCalendar duration = new HighResolutionCalendar();
        HighResolutionCalendarParser.setRelativeTime((String)this.txtDuration.getText(), (HighResolutionCalendar)duration);
        return duration;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateWidgets();
    }

    private void updateWidgets() {
        boolean enableDuration = this.radioDuration.getSelection();
        this.txtDuration.setEnabled(enableDuration);
        this.txtNofFrames.setEnabled(!enableDuration);
        this.type = enableDuration ? FlowSizeType.DURATION : FlowSizeType.NOF_FRAMES;
    }

    public FlowSizeType getFlowSizeType() {
        return this.type;
    }

    public BigInteger getNofFrames() {
        return new BigInteger(this.txtNofFrames.getText());
    }

    public static enum FlowSizeType {
        NOF_FRAMES,
        DURATION;

    }
}

