/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.text.DoubleTextFactory;
import com.excentis.products.byteblower.gui.widgets.composites.IRateCompositeListener;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class RateComposite
extends ByteBlowerComposite
implements ModifyListener,
SelectionListener,
Adapter {
    public static final int FIXED_INTENDED_LOAD = 0;
    public static final int FIXED_PHYSICAL_LOAD = 1;
    public static final int FIXED_FRAME_INTERVAL = 2;
    public static final int FIXED_FRAME_RATE = 3;
    private int fixedType = 0;
    private FrameBlastingFlowController intervalController;
    private FrameBlastingFlowController throughputController;
    private boolean useRadioButtons;
    private ByteBlowerProjectReader projectReader;
    private Text textIntendedLoad;
    private Combo comboIntendedLoadUnit;
    private Text textPhysicalLoad;
    private Combo comboPhysicalLoadUnit;
    private Text textFrameInterval;
    private Text textFrameRate;
    private Button radioIntendedLoad;
    private Button radioPhysicalLoad;
    private Button radioFrameInterval;
    private Button radioFrameRate;
    private Label lblThroughputWarning;
    private List<IRateCompositeListener> listeners;
    private boolean allowNotifies = true;

    public RateComposite(Composite parent, int style, ByteBlowerProjectReader projectReader, FrameBlastingFlowController tempController) {
        super(parent, style);
        boolean bl = this.useRadioButtons = tempController == null;
        if (this.useRadioButtons) {
            ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
            FrameBlastingFlow forInterval = factory.createFrameBlastingFlow();
            this.intervalController = ControllerFactory.create((FrameBlastingFlow)forInterval);
            FrameBlastingFlow forThroughput = factory.createFrameBlastingFlow();
            this.throughputController = ControllerFactory.create((FrameBlastingFlow)forThroughput);
            FrameBlastingFrame dummyFrameBlastingFrame = factory.createFrameBlastingFrame();
            forThroughput.getFrameBlastingFrames().add((Object)dummyFrameBlastingFrame);
            Frame dummyFrame = factory.createFrame();
            FrameController.initializeFrame_Ipv4_UDP((Frame)dummyFrame);
            dummyFrameBlastingFrame.setFrame(dummyFrame);
            ThroughputType type = projectReader.getThroughputType();
            this.throughputController.setThroughput(BigDecimal.ONE, DataRateUnit.MBPS, type, false).execute();
        } else {
            this.intervalController = tempController;
            this.throughputController = tempController;
            this.adaptToFrames(tempController);
        }
        this.intervalController.addAdapter((Adapter)this);
        this.throughputController.addAdapter((Adapter)this);
        this.projectReader = this.getProjectReader();
        this.initialize();
    }

    private void adaptToFrames(FrameBlastingFlowController controller) {
        for (FrameController frameController : controller.getUniqueFrameControllers()) {
            frameController.addAdapter((Adapter)this);
        }
    }

    public RateComposite(Composite parent, int style, ByteBlowerProjectReader projectReader) {
        this(parent, style, projectReader, null);
    }

    public void addRateModificationListener(IRateCompositeListener listener) {
        this.getListeners().add(listener);
    }

    private List<IRateCompositeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IRateCompositeListener>();
        }
        return this.listeners;
    }

    private void notifyListeners() {
        for (IRateCompositeListener listener : this.getListeners()) {
            listener.rateChanged();
        }
    }

    public RateComposite(Composite parent, int style, FrameBlastingFlowController tempController) {
        this(parent, style, tempController.getProjectReader(), tempController);
    }

    public void dispose() {
        this.intervalController.removeAdapter((Adapter)this);
        this.throughputController.removeAdapter((Adapter)this);
        super.dispose();
    }

    private void initialize() {
        DataRateUnit dataRateUnit;
        Label label;
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        if (this.useRadioButtons) {
            this.radioIntendedLoad = new Button((Composite)this, 16);
            this.radioIntendedLoad.setText("Fixed Intended Load:");
            this.radioIntendedLoad.addSelectionListener((SelectionListener)this);
        } else {
            label = new Label((Composite)this, 0);
            label.setText("Intended Load:");
        }
        this.textIntendedLoad = DoubleTextFactory.instance().create((Composite)this, 2048, 12);
        this.textIntendedLoad.setLayoutData((Object)new GridData(768));
        this.textIntendedLoad.addModifyListener((ModifyListener)this);
        this.comboIntendedLoadUnit = new Combo((Composite)this, 76);
        DataRateUnit[] dataRateUnitArray = DataRateUnit.values();
        int n = dataRateUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            dataRateUnit = dataRateUnitArray[n2];
            this.comboIntendedLoadUnit.add(dataRateUnit.getName());
            ++n2;
        }
        this.comboIntendedLoadUnit.addSelectionListener((SelectionListener)this);
        this.comboIntendedLoadUnit.select(this.throughputController.getDataRateUnit().getValue());
        if (this.useRadioButtons) {
            this.radioPhysicalLoad = new Button((Composite)this, 16);
            this.radioPhysicalLoad.setText("Fixed Physical Load:");
            this.radioPhysicalLoad.addSelectionListener((SelectionListener)this);
        } else {
            label = new Label((Composite)this, 0);
            label.setText("Physical Load:");
        }
        this.textPhysicalLoad = DoubleTextFactory.instance().create((Composite)this, 2048, 12);
        this.textPhysicalLoad.setLayoutData((Object)new GridData(768));
        this.textPhysicalLoad.addModifyListener((ModifyListener)this);
        this.comboPhysicalLoadUnit = new Combo((Composite)this, 76);
        dataRateUnitArray = DataRateUnit.values();
        n = dataRateUnitArray.length;
        n2 = 0;
        while (n2 < n) {
            dataRateUnit = dataRateUnitArray[n2];
            this.comboPhysicalLoadUnit.add(dataRateUnit.getName());
            ++n2;
        }
        this.comboPhysicalLoadUnit.addSelectionListener((SelectionListener)this);
        this.comboPhysicalLoadUnit.select(this.throughputController.getDataRateUnit().getValue());
        if (this.useRadioButtons) {
            this.radioFrameInterval = new Button((Composite)this, 16);
            this.radioFrameInterval.setText("Fixed " + Messages.getString("FrameBlastingSettingsDialog.general.frameinterval"));
            this.radioFrameInterval.addSelectionListener((SelectionListener)this);
            this.radioFrameInterval.setSelection(true);
        } else {
            label = new Label((Composite)this, 0);
            label.setText(Messages.getString("FrameBlastingSettingsDialog.general.frameinterval"));
        }
        this.textFrameInterval = TimeTextFactory.instance().create((Composite)this, 2048);
        this.textFrameInterval.setLayoutData((Object)new GridData(768));
        this.textFrameInterval.addModifyListener((ModifyListener)this);
        label = new Label((Composite)this, 0);
        label.setText("Time");
        if (this.useRadioButtons) {
            this.radioFrameRate = new Button((Composite)this, 16);
            this.radioFrameRate.setText("Fixed " + Messages.getString("FrameBlastingSettingsDialog.general.framerate"));
            this.radioFrameRate.addSelectionListener((SelectionListener)this);
        } else {
            label = new Label((Composite)this, 0);
            label.setText(Messages.getString("FrameBlastingSettingsDialog.general.framerate"));
        }
        this.textFrameRate = DoubleTextFactory.instance().create((Composite)this, 2048, 12);
        this.textFrameRate.setLayoutData((Object)new GridData(768));
        this.textFrameRate.addModifyListener((ModifyListener)this);
        this.textFrameRate.setTextLimit(20);
        label = new Label((Composite)this, 0);
        label.setText("Frames/s");
        this.updateWidgets();
        this.updateInfo();
    }

    public void modifyText(ModifyEvent e) {
        BigDecimal frameRate;
        String input;
        Control control = (Control)e.widget;
        if (this.textIntendedLoad.isDisposed() || this.textPhysicalLoad.isDisposed() || this.textFrameRate.isDisposed()) {
            return;
        }
        if (!control.isFocusControl() || !this.allowNotifies) {
            return;
        }
        Command tempCommand = null;
        if (control == this.textIntendedLoad) {
            String input2 = this.textIntendedLoad.getText();
            if (!input2.isEmpty()) {
                BigDecimal throughput = new BigDecimal(input2, MathContext.DECIMAL128);
                ThroughputType throughputType = this.projectReader.getThroughputType();
                tempCommand = this.throughputController.setThroughput(throughput, throughputType, false);
            }
        } else if (control == this.textPhysicalLoad) {
            String input3 = this.textPhysicalLoad.getText();
            if (!input3.isEmpty()) {
                BigDecimal throughput = new BigDecimal(input3, MathContext.DECIMAL128);
                tempCommand = this.throughputController.setThroughput(throughput, ThroughputType.FRAME_AND_ALL_OTHER_FIELDS, false);
            }
        } else if (control == this.textFrameInterval) {
            String intervalTxt = this.textFrameInterval.getText();
            if (!intervalTxt.isEmpty()) {
                HighResolutionCalendar duration = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)intervalTxt, (HighResolutionCalendar)duration);
                if (duration.getTimeInNanoseconds() != 0L) {
                    tempCommand = this.intervalController.setFrameInterval(duration);
                }
            }
        } else if (control == this.textFrameRate && !(input = this.textFrameRate.getText()).isEmpty() && (frameRate = new BigDecimal(input, MathContext.DECIMAL128)).compareTo(BigDecimal.ZERO) == 1) {
            tempCommand = this.intervalController.setFrameRate(frameRate);
        }
        if (tempCommand == null) {
            control.setForeground(ExcentisColors.red);
        } else {
            this.textFrameInterval.setForeground(null);
            this.textFrameRate.setForeground(null);
            this.textIntendedLoad.setForeground(null);
            this.textPhysicalLoad.setForeground(null);
            tempCommand.execute();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.comboIntendedLoadUnit.addSelectionListener(listener);
    }

    public HighResolutionCalendar getFrameInterval() {
        return this.intervalController.getFrameInterval();
    }

    public BigDecimal getFrameRate() {
        return this.intervalController.getFrameRate();
    }

    public BigDecimal getThroughput(ThroughputType throughputType) {
        return this.throughputController.getThroughput(throughputType);
    }

    public DataRateUnit getThroughputUnit() {
        return this.throughputController.getDataRateUnit();
    }

    private DataRateUnit getThroughputUnit(Combo comboLoadUnit) {
        int index = comboLoadUnit.getSelectionIndex();
        return DataRateUnit.get((int)index);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        Control control = (Control)e.widget;
        if (!this.allowNotifies) {
            return;
        }
        if (control instanceof Combo) {
            control.setFocus();
            DataRateUnit unit = this.getThroughputUnit((Combo)control);
            this.throughputController.setDataRateUnit(unit).execute();
        } else if (control instanceof Button) {
            this.updateWidgets();
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object arg0) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (this.textFrameInterval == null || !this.allowNotifies || !this.notifierIsMine(notifier) || this.textFrameInterval.isDisposed()) {
            return;
        }
        try {
            this.allowNotifies = false;
            switch (notification.getFeatureID(FrameBlastingFlow.class)) {
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    wb.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RateComposite.this.updateInfo();
                            RateComposite.this.notifyListeners();
                        }
                    });
                    break;
                }
            }
        }
        finally {
            this.allowNotifies = true;
        }
    }

    private boolean notifierIsMine(Object notifier) {
        return notifier == this.intervalController.getObject() || notifier == this.throughputController.getObject();
    }

    private void updateInfo() {
        if (this.textFrameInterval.isDisposed()) {
            return;
        }
        if (!this.textIntendedLoad.isFocusControl()) {
            ThroughputType throughputType = this.projectReader.getThroughputType();
            String throughput = this.throughputController.getThroughputString(throughputType);
            this.textIntendedLoad.setText(throughput);
        }
        if (!this.textPhysicalLoad.isFocusControl()) {
            String throughput = this.throughputController.getThroughputString(ThroughputType.FRAME_AND_ALL_OTHER_FIELDS);
            this.textPhysicalLoad.setText(throughput);
        }
        if (!this.textFrameInterval.isFocusControl()) {
            HighResolutionCalendar frameInterval = this.intervalController.getFrameInterval();
            String durationTxt = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)frameInterval, (boolean)false, (boolean)true);
            this.textFrameInterval.setText(durationTxt);
        }
        if (!this.textFrameRate.isFocusControl()) {
            this.textFrameRate.setText(Utils.trim((String)this.intervalController.getFrameRate().toString(), (int)6));
        }
        if (this.useRadioButtons || !this.throughputController.getFrameBlastingFrames().isEmpty()) {
            if (this.lblThroughputWarning != null) {
                this.lblThroughputWarning.setText("");
            }
        } else {
            if (this.lblThroughputWarning == null) {
                this.lblThroughputWarning = new Label((Composite)this, 0);
            }
            this.lblThroughputWarning.setText("Add Frames to see the Intended Load.");
        }
        int unitIndex = this.throughputController.getDataRateUnit().getValue();
        this.comboIntendedLoadUnit.select(unitIndex);
        this.comboPhysicalLoadUnit.select(unitIndex);
    }

    public void setTarget(Notifier arg0) {
    }

    public int getFixedType() {
        return this.fixedType;
    }

    public void addModifyListener(boolean frameRateAlso, ModifyListener listener) {
        this.textIntendedLoad.addModifyListener(listener);
        this.textPhysicalLoad.addModifyListener(listener);
        if (frameRateAlso) {
            this.textFrameRate.addModifyListener(listener);
        }
        this.textFrameInterval.addModifyListener(listener);
    }

    public boolean isComplete() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    public void updateWidgets() {
        if (this.useRadioButtons) {
            try {
                this.allowNotifies = false;
                if (this.radioIntendedLoad.getSelection()) {
                    this.fixedType = 0;
                } else if (this.radioPhysicalLoad.getSelection()) {
                    this.fixedType = 1;
                } else if (this.radioFrameInterval.getSelection()) {
                    this.fixedType = 2;
                } else if (this.radioFrameRate.getSelection()) {
                    this.fixedType = 3;
                }
                this.textIntendedLoad.setEnabled(this.radioIntendedLoad.getSelection());
                this.comboIntendedLoadUnit.setEnabled(this.radioIntendedLoad.getSelection());
                this.textPhysicalLoad.setEnabled(this.radioPhysicalLoad.getSelection());
                this.comboPhysicalLoadUnit.setEnabled(this.radioPhysicalLoad.getSelection());
                this.textPhysicalLoad.setEnabled(this.radioPhysicalLoad.getSelection());
                this.comboPhysicalLoadUnit.setEnabled(this.radioPhysicalLoad.getSelection());
                this.textFrameInterval.setEnabled(this.radioFrameInterval.getSelection());
                this.textFrameRate.setEnabled(this.radioFrameRate.getSelection());
            }
            finally {
                this.allowNotifies = true;
            }
        }
    }
}

