/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class GeneralPropertiesComposite
extends PropertiesComposite
implements VerifyListener {
    protected IWorkbench workbench;
    private Text txtName;
    private Text txtAuthor;
    private static String editPattern = "^(((\\d?\\d?)?([.]\\d?\\d?)?)?)$";
    public static final VerifyListener noAccentOrPercent = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            Text t = (Text)e.widget;
            String previous = t.getText();
            String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
            e.doit = true;
            if (result.indexOf("'") != -1) {
                e.doit = false;
            }
            if (result.indexOf("\"") != -1) {
                e.doit = false;
            }
            if (result.indexOf("%") != -1) {
                e.doit = false;
            }
        }
    };

    public void verifyText(VerifyEvent e) {
        Text t = (Text)e.widget;
        String previous = t.getText();
        String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
        e.doit = Pattern.matches(editPattern, result);
    }

    public GeneralPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    protected void createContents() {
        String author;
        String projectName;
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)new GridLayout(2, false));
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        if (project != null) {
            projectName = project.getName();
            author = project.getAuthor();
        } else {
            projectName = ByteBlowerPreferences.getDefaultProjectName();
            author = ByteBlowerPreferences.getDefaultAuthor();
        }
        Label lblName = new Label((Composite)this, 0);
        lblName.setText(Messages.getString("ProjectPropertiesDialog.ProjectName"));
        this.txtName = new Text((Composite)this, 2048);
        this.txtName.setTextLimit(60);
        this.txtName.setText(projectName);
        GridData gridData = new GridData(768);
        this.txtName.setLayoutData((Object)gridData);
        this.txtName.addVerifyListener(noAccentOrPercent);
        Label lblAuthor = new Label((Composite)this, 0);
        lblAuthor.setText(Messages.getString("ProjectPropertiesDialog.Author"));
        this.txtAuthor = new Text((Composite)this, 2048);
        this.txtAuthor.setTextLimit(60);
        if (author != null) {
            this.txtAuthor.setText(author);
        }
        this.txtAuthor.addVerifyListener(noAccentOrPercent);
        this.txtAuthor.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void performOk() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String oldName = project.getName();
        String oldAuthor = project.getAuthor();
        String newName = this.getProjectName();
        String newAuthor = this.getProjectAuthor();
        if (!newName.equals(oldName)) {
            project.setName(newName);
        }
        if (!newAuthor.equals(oldAuthor)) {
            project.setAuthor(newAuthor);
        }
    }

    public String getProjectName() {
        return this.txtName.getText().trim();
    }

    public String getProjectAuthor() {
        return this.txtAuthor.getText().trim();
    }

    @Override
    public void setAsDefault() {
        ByteBlowerPreferences.setDefaultAuthor((String)this.getProjectAuthor());
        ByteBlowerPreferences.setDefaultProjectName((String)this.getProjectName());
    }
}

