/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class HistogramPropertiesComposite
extends PropertiesComposite
implements VerifyListener,
ModifyListener {
    protected IWorkbench workbench;
    private Text minLatencyRange;
    private Text maxLatencyRange;
    private final Long minNanos = new Long("20000");
    private final Long maxNanos = new Long("10000000000");
    private final HighResolutionCalendar minRange = new HighResolutionCalendar(this.minNanos);
    private final HighResolutionCalendar maxRangeEnd = new HighResolutionCalendar(this.maxNanos);
    private static String editPattern = "^(((\\d?\\d?)?([.]\\d?\\d?)?)?)$";

    public HistogramPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    private boolean isRangeBigEnough() {
        HighResolutionCalendar maxtime;
        HighResolutionCalendar mintime;
        String rangeStart = this.minLatencyRange.getText();
        if (!HighResolutionCalendarParser.setRelativeTime((String)rangeStart, (HighResolutionCalendar)(mintime = new HighResolutionCalendar()))) {
            return false;
        }
        String rangeEnd = this.maxLatencyRange.getText();
        if (!HighResolutionCalendarParser.setRelativeTime((String)rangeEnd, (HighResolutionCalendar)(maxtime = new HighResolutionCalendar()))) {
            return false;
        }
        HighResolutionCalendar range = maxtime.subtractRelative(mintime);
        return range.compareTo((Calendar)this.minRange) >= 0;
    }

    private String getWarningMessage() {
        HighResolutionCalendar maxtime;
        HighResolutionCalendar mintime;
        String errorMessage = null;
        String rangeStart = this.minLatencyRange.getText();
        if (!HighResolutionCalendarParser.setRelativeTime((String)rangeStart, (HighResolutionCalendar)(mintime = new HighResolutionCalendar()))) {
            return null;
        }
        String rangeEnd = this.maxLatencyRange.getText();
        if (!HighResolutionCalendarParser.setRelativeTime((String)rangeEnd, (HighResolutionCalendar)(maxtime = new HighResolutionCalendar()))) {
            return null;
        }
        if (maxtime.compareTo((Calendar)this.maxRangeEnd) > 0) {
            errorMessage = "The maximum Range End is 10s";
        } else if (mintime.compareTo((Calendar)maxtime) >= 0) {
            errorMessage = "The Range End must be bigger than the Range Start";
        } else if (!this.isRangeBigEnough()) {
            errorMessage = "The Range must be at least 20000 ns";
        }
        return errorMessage;
    }

    private void updateErrorMessage() {
        this.setInvalid(this.getWarningMessage());
    }

    private void createLatencyTab(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText("Range Start:");
        this.minLatencyRange = TimeTextFactory.instance().create(composite, 2048, this.maxRangeEnd);
        this.minLatencyRange.setLayoutData((Object)new GridData(768));
        this.minLatencyRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Text t = (Text)arg0.widget;
                String timeText = t.getText();
                HighResolutionCalendar currentTime = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)timeText, (HighResolutionCalendar)currentTime);
                HighResolutionCalendar maxTime = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)HistogramPropertiesComposite.this.maxLatencyRange.getText(), (HighResolutionCalendar)maxTime);
                HistogramPropertiesComposite.this.updateErrorMessage();
            }
        });
        label = new Label(composite, 0);
        label.setText("Range End:");
        this.maxLatencyRange = TimeTextFactory.instance().create(composite, 2048, this.maxRangeEnd);
        this.maxLatencyRange.setLayoutData((Object)new GridData(768));
        this.maxLatencyRange.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Text t = (Text)arg0.widget;
                String timeText = t.getText();
                HighResolutionCalendar currentTime = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)timeText, (HighResolutionCalendar)currentTime);
                HighResolutionCalendar minTime = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)HistogramPropertiesComposite.this.minLatencyRange.getText(), (HighResolutionCalendar)minTime);
                currentTime.after((Object)HistogramPropertiesComposite.this.maxRangeEnd);
                HistogramPropertiesComposite.this.updateErrorMessage();
            }
        });
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String time = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)(currentProject == null ? new HighResolutionCalendar(new Long(ByteBlowerPreferences.getLatencyRangeStart())) : currentProject.getLatencyRangeStart()), (boolean)false, (boolean)true);
        this.minLatencyRange.setText(time);
        time = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)(currentProject == null ? new HighResolutionCalendar(new Long(ByteBlowerPreferences.getLatencyRangeEnd())) : currentProject.getLatencyRangeEnd()), (boolean)false, (boolean)true);
        this.maxLatencyRange.setText(time);
        label = new Label(composite, 0);
        label.setText("To create the latency histogram graph, the specified range is divided into one thousand buckets.");
        label.setLayoutData((Object)new GridData(768));
    }

    public void verifyText(VerifyEvent e) {
        Text t = (Text)e.widget;
        String previous = t.getText();
        String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
        e.doit = Pattern.matches(editPattern, result);
    }

    public void modifyText(ModifyEvent e) {
        this.updateErrorMessage();
    }

    protected void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.createLatencyTab(this);
        this.updateErrorMessage();
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String minRange = this.minLatencyRange.getText();
        String maxRange = this.maxLatencyRange.getText();
        HighResolutionCalendar mintime = new HighResolutionCalendar();
        boolean success = HighResolutionCalendarParser.setRelativeTime((String)minRange, (HighResolutionCalendar)mintime);
        if (!success) {
            return;
        }
        HighResolutionCalendar maxtime = new HighResolutionCalendar();
        success = HighResolutionCalendarParser.setRelativeTime((String)maxRange, (HighResolutionCalendar)maxtime);
        if (!success) {
            return;
        }
        if (currentProject.getLatencyRangeStart() == mintime && currentProject.getLatencyRangeEnd() == maxtime) {
            return;
        }
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setMinLatencyRange(mintime));
        compCommCtlr.appendCommand(projectCtlr.setMaxLatencyRange(maxtime));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "Report project preferences", compCommCtlr.unwrap());
        operation.run();
    }

    @Override
    public void setAsDefault() {
        String maxLatencyRangeString;
        HighResolutionCalendar time;
        String minLatencyRangeString = this.minLatencyRange.getText();
        if (HighResolutionCalendarParser.setRelativeTime((String)minLatencyRangeString, (HighResolutionCalendar)(time = new HighResolutionCalendar()))) {
            String timeoutInNanos = time.toString();
            ByteBlowerPreferences.setLatencyRangeStart((String)timeoutInNanos);
        }
        if (HighResolutionCalendarParser.setRelativeTime((String)(maxLatencyRangeString = this.maxLatencyRange.getText()), (HighResolutionCalendar)time)) {
            String timeoutInNanos = time.toString();
            ByteBlowerPreferences.setLatencyRangeEnd((String)timeoutInNanos);
        }
    }
}

