/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.DhcpPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.GeneralPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.HistogramPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.IProjectProperties;
import com.excentis.products.byteblower.gui.widgets.dialogs.LossPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.OutputPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.ScenarioPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.ThroughputPropertiesComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;

public class ProjectPropertiesDialog
extends Dialog
implements SelectionListener {
    protected IWorkbench workbench;
    Button btnOk;
    Button btnCancel;
    Label lblInfo;
    TabFolder topfolder;
    List<IProjectProperties> propertyTabs;
    Map<IProjectProperties, String> errors = new HashMap<IProjectProperties, String>();
    GeneralPropertiesComposite generalPropertiesComposite;
    ThroughputPropertiesComposite ThroughputPropertiesComposite;
    DhcpPropertiesComposite DhcpPropertiesComposite;
    OutputPropertiesComposite OutputPropertiesComposite;
    LossPropertiesComposite LossPropertiesComposite;
    HistogramPropertiesComposite HistogramPropertiesComposite;
    ScenarioPropertiesComposite ScenarioPropertiesComposite;
    int startTabIndex = 0;

    public ProjectPropertiesDialog(Shell parent) {
        super(parent);
    }

    public ProjectPropertiesDialog(Shell parent, int startTabIndex) {
        this(parent);
        this.startTabIndex = startTabIndex;
    }

    private Composite addTab(TabFolder topfolder, String title, String image) {
        TabItem tab = new TabItem(topfolder, 0);
        tab.setText(title);
        ImageDescriptor lossImageDescr = ImageDescriptor.createFromFile(ImageCache.class, (String)image);
        tab.setImage(lossImageDescr.createImage());
        Composite composite = new Composite((Composite)topfolder, 0);
        tab.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText("Project Properties");
        parent.setLayout((Layout)new GridLayout(4, false));
        this.topfolder = new TabFolder(parent, 0);
        GridData gridData = new GridData(2);
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        this.topfolder.setLayoutData((Object)gridData);
        this.topfolder.addSelectionListener((SelectionListener)this);
        Composite tab = this.addTab(this.topfolder, "General", "preferences/port.gif");
        this.generalPropertiesComposite = new GeneralPropertiesComposite(tab);
        this.register(this.generalPropertiesComposite);
        tab = this.addTab(this.topfolder, "Bitrate", "preferences/frame.gif");
        this.register(new ThroughputPropertiesComposite(tab));
        tab = this.addTab(this.topfolder, "DHCP", "preferences/dhcp.gif");
        this.register(new DhcpPropertiesComposite(tab));
        tab = this.addTab(this.topfolder, "Report", "preferences/output.gif");
        this.register(new OutputPropertiesComposite(tab));
        tab = this.addTab(this.topfolder, "Loss", "preferences/loss.gif");
        this.register(new LossPropertiesComposite(tab));
        tab = this.addTab(this.topfolder, "Latency", "preferences/distribution.gif");
        this.register(new HistogramPropertiesComposite(tab));
        tab = this.addTab(this.topfolder, "Scenario", "preferences/scenario.gif");
        this.register(new ScenarioPropertiesComposite(tab));
        this.topfolder.setSelection(this.startTabIndex);
        this.lblInfo = new Label(parent, 64);
        gridData = new GridData(2);
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        this.lblInfo.setLayoutData((Object)gridData);
        Button filler = new Button(parent, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(768));
        this.btnOk = new Button(parent, 0);
        this.btnOk.setText("Apply and Close");
        this.btnOk.setLayoutData((Object)new GridData(3));
        this.btnOk.addSelectionListener((SelectionListener)this);
        this.btnCancel = new Button(parent, 0);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.updateInfo();
        return this.topfolder;
    }

    private void register(IProjectProperties properties) {
        if (this.propertyTabs == null) {
            this.propertyTabs = new ArrayList<IProjectProperties>();
        }
        this.propertyTabs.add(properties);
        properties.setErrorHandler(this);
    }

    public void performOk() {
        for (IProjectProperties tab : this.propertyTabs) {
            tab.performOk();
        }
    }

    private void setAsDefault() {
        for (IProjectProperties tab : this.propertyTabs) {
            tab.setAsDefault();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnOk) {
            if (ByteBlowerGuiResourceController.getProject() == null) {
                this.setAsDefault();
            } else {
                this.performOk();
            }
            this.close();
        } else if (e.widget == this.btnCancel) {
            this.close();
        } else if (e.widget == this.topfolder) {
            this.updateInfo();
        }
    }

    private IProjectProperties getCurrentTab() {
        int tabIndex = this.topfolder.getSelectionIndex();
        IProjectProperties tab = this.propertyTabs.get(tabIndex);
        return tab;
    }

    private void updateInfo() {
        if (this.propertyTabs == null) {
            return;
        }
        IProjectProperties tab = this.getCurrentTab();
        String info = this.errors.get(tab);
        if (info == null) {
            if (ByteBlowerGuiResourceController.getProject() == null) {
                this.lblInfo.setForeground(ExcentisColors.orange);
                info = "Currently there is no project opened. The specified settings will be used when you create a new project.\nExisting projects will not be affected.";
            } else {
                info = "";
            }
        } else {
            this.lblInfo.setForeground(ExcentisColors.red);
        }
        this.lblInfo.setText(info);
        this.lblInfo.pack();
        this.getShell().pack();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setInvalid(IProjectProperties tab, String errorMessage) {
        if (errorMessage == null) {
            this.errors.remove(tab);
        } else {
            this.errors.put(tab, errorMessage);
        }
        this.updateInfo();
        boolean enable = this.errors.isEmpty();
        this.btnOk.setEnabled(enable);
    }
}

