/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ScenarioPropertiesComposite
extends PropertiesComposite {
    private static final String heartbeatInfoOn = "There will be periodic communication with the ByteBlower Endpoints while a scenario is running.\nThis way, when canceling a scenario, you don't have to abort the ByteBlower Endpoints manually.";
    private static final String heartbeatInfoOff = "Silent Mode. There will be no communication with the ByteBlower Endpoints while a scenario is running.\nWhen canceling a scenario, you have to abort the ByteBlower Endpoints manually.";
    public static final String SCENARIO_HEARTBEAT_INFO_URL = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/canceling-scenarios-on-wireless-endpoints";
    private Button btnIdenticalFramesWarning;
    private Button btnPauseAfterDhcp;
    private Button btnEnableScoutingFrames;
    private Button btnIgnoreInitializationErrors;
    private Button btnEnableAutomaticTcpRestart;
    private Text txtWaitTimeAfterScenario;
    protected IWorkbench workbench;
    private Text txtHeartBeatInterval;
    private Button btnKeepHeartBeating;
    private Button btnHeartBeatHelp;

    public ScenarioPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    protected void createContents() {
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)new GridLayout());
        this.btnIdenticalFramesWarning = new Button((Composite)this, 32);
        this.btnIdenticalFramesWarning.setText("Show a warning if identical frames are found.");
        this.btnPauseAfterDhcp = new Button((Composite)this, 32);
        this.btnPauseAfterDhcp.setText("Pause after initializing the test setup. After performing DHCP/Auto Configuration, a dialog will pop up.");
        this.btnIgnoreInitializationErrors = new Button((Composite)this, 32);
        this.btnIgnoreInitializationErrors.setText("Ignore Initialization Errors.");
        this.btnEnableScoutingFrames = new Button((Composite)this, 32);
        this.btnEnableScoutingFrames.setText("Enable Scouting Frames.");
        this.btnEnableAutomaticTcpRestart = new Button((Composite)this, 32);
        this.btnEnableAutomaticTcpRestart.setText("Enable Automatic TCP Restart.");
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText("Time to wait for packets after the scenario finished:");
        this.txtWaitTimeAfterScenario = TimeTextFactory.instance().create(composite, 2048);
        this.txtWaitTimeAfterScenario.setLayoutData((Object)new GridData(768));
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("Wireless Endpoints");
        this.btnKeepHeartBeating = new Button((Composite)group, 32);
        this.btnKeepHeartBeating.setText("Keep contact with each ByteBlower Endpoint, every:");
        this.txtHeartBeatInterval = TimeTextFactory.instance().create((Composite)group, 2048);
        this.txtHeartBeatInterval.setText("5s");
        this.txtHeartBeatInterval.addTraverseListener(event -> {
            if (event.detail == 4) {
                this.txtHeartBeatInterval.getParent().forceFocus();
            }
        });
        this.txtHeartBeatInterval.setLayoutData((Object)new GridData(768));
        this.btnKeepHeartBeating.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioPropertiesComposite.this.txtHeartBeatInterval.setEnabled(ScenarioPropertiesComposite.this.btnKeepHeartBeating.getSelection());
                ScenarioPropertiesComposite.this.updateHeartBeatToolTip();
            }
        });
        this.btnHeartBeatHelp = new Button((Composite)group, 0);
        this.btnHeartBeatHelp.setText("?");
        this.btnHeartBeatHelp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(ScenarioPropertiesComposite.SCENARIO_HEARTBEAT_INFO_URL));
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showValues();
    }

    private void updateHeartBeatToolTip() {
        String tooltip = this.btnKeepHeartBeating.getSelection() ? heartbeatInfoOn : heartbeatInfoOff;
        this.btnKeepHeartBeating.setToolTipText(tooltip);
        this.txtHeartBeatInterval.setToolTipText(tooltip);
        this.btnHeartBeatHelp.setToolTipText(tooltip);
    }

    private void showValues() {
        long heartbeatInterval;
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        boolean check = currentProject == null ? ByteBlowerPreferences.getIdenticalFramesWarning() : currentProject.isScenarioIdenticalFramesWarning();
        this.btnIdenticalFramesWarning.setSelection(check);
        check = currentProject == null ? ByteBlowerPreferences.getPauseAfterDhcp() : currentProject.isScenarioPauseAfterDhcp();
        this.btnPauseAfterDhcp.setSelection(check);
        check = currentProject == null ? ByteBlowerPreferences.getEnableScoutingFrames() : currentProject.isScenarioEnableScoutingFrames();
        this.btnEnableScoutingFrames.setSelection(check);
        check = currentProject == null ? ByteBlowerPreferences.getIgnoreInitializationErrors() : currentProject.isScenarioIgnoreInitializationErrors();
        this.btnIgnoreInitializationErrors.setSelection(check);
        String initialization = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)(currentProject == null ? new HighResolutionCalendar(ByteBlowerPreferences.getWaitTimeAfterScenario()) : currentProject.getScenarioWaitTimeAfterScenario()), (boolean)false, (boolean)true);
        this.txtWaitTimeAfterScenario.setText(initialization);
        check = currentProject == null ? ByteBlowerPreferences.getEnableAutomaticTcpRestart() : currentProject.isScenarioAutomaticTcpRestart();
        this.btnEnableAutomaticTcpRestart.setSelection(check);
        long l = heartbeatInterval = currentProject == null ? ByteBlowerPreferences.getDefaultScenarioHeartbeatInterval() : currentProject.getScenarioHeartbeatInterval();
        if (heartbeatInterval == 0L) {
            heartbeatInterval = ByteBlowerProjectReader.BYTE_BLOWER_PROJECT__SCENARIO_HEARTBEAT_INTERVAL_OFF;
        }
        boolean shouldKeepHeartBeat = heartbeatInterval < ByteBlowerProjectReader.BYTE_BLOWER_PROJECT__SCENARIO_HEARTBEAT_INTERVAL_OFF;
        this.btnKeepHeartBeating.setSelection(shouldKeepHeartBeat);
        this.updateHeartBeatToolTip();
        this.txtHeartBeatInterval.setEnabled(shouldKeepHeartBeat);
        if (shouldKeepHeartBeat) {
            this.txtHeartBeatInterval.setText(HighResolutionCalendarParser.getRelativeTime((long)heartbeatInterval));
        } else {
            this.txtHeartBeatInterval.setText("5s");
        }
    }

    public Long getScenarioHeartbeatInterval() {
        if (this.btnKeepHeartBeating.getSelection()) {
            String userTime = this.txtHeartBeatInterval.getText();
            HighResolutionCalendar pp = new HighResolutionCalendar();
            HighResolutionCalendarParser.parseToRelativeTime((String)userTime, (HighResolutionCalendar)pp);
            return pp.getTimeInNanoseconds();
        }
        return ByteBlowerProjectReader.BYTE_BLOWER_PROJECT__SCENARIO_HEARTBEAT_INTERVAL_OFF;
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        boolean identicalFramesWarning = this.btnIdenticalFramesWarning.getSelection();
        boolean pauseAfterDhcp = this.btnPauseAfterDhcp.getSelection();
        boolean enableScoutingFrames = this.btnEnableScoutingFrames.getSelection();
        boolean ignoreInitErrors = this.btnIgnoreInitializationErrors.getSelection();
        HighResolutionCalendar waitTimeAfterScenario = new HighResolutionCalendar();
        boolean success = HighResolutionCalendarParser.setRelativeTime((String)this.txtWaitTimeAfterScenario.getText(), (HighResolutionCalendar)waitTimeAfterScenario);
        if (!success) {
            return;
        }
        boolean enableAutomaticTcpRestart = this.btnEnableAutomaticTcpRestart.getSelection();
        Long scenarioHeartbeatInterval = this.getScenarioHeartbeatInterval();
        if (currentProject.isScenarioIdenticalFramesWarning() == identicalFramesWarning && currentProject.isScenarioPauseAfterDhcp() == pauseAfterDhcp && currentProject.isScenarioEnableScoutingFrames() == enableScoutingFrames && currentProject.isScenarioIgnoreInitializationErrors() == ignoreInitErrors && currentProject.getScenarioWaitTimeAfterScenario().equals((Object)waitTimeAfterScenario) && currentProject.isScenarioAutomaticTcpRestart() == enableAutomaticTcpRestart && currentProject.getScenarioHeartbeatInterval() == scenarioHeartbeatInterval.longValue()) {
            return;
        }
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setScenarioIdenticalFramesWarning(identicalFramesWarning));
        compCommCtlr.appendCommand(projectCtlr.setScenarioPauseAfterDhcp(pauseAfterDhcp));
        compCommCtlr.appendCommand(projectCtlr.setScenarioIgnoreInitializationErrors(ignoreInitErrors));
        compCommCtlr.appendCommand(projectCtlr.setScenarioEnableScoutingFrames(enableScoutingFrames));
        compCommCtlr.appendCommand(projectCtlr.setScenarioAutomaticTcpRestart(enableAutomaticTcpRestart));
        compCommCtlr.appendCommand(projectCtlr.setScenarioWaitTimeAfterScenario(waitTimeAfterScenario));
        compCommCtlr.appendCommand(projectCtlr.setScenarioHeartbeatInterval(scenarioHeartbeatInterval));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "Scenario project preferences", compCommCtlr.unwrap());
        operation.run();
    }

    @Override
    public void setAsDefault() {
        boolean check = this.btnIdenticalFramesWarning.getSelection();
        ByteBlowerPreferences.setIdenticalFramesWarning((boolean)check);
        check = this.btnPauseAfterDhcp.getSelection();
        ByteBlowerPreferences.setPauseAfterDhcp((boolean)check);
        check = this.btnEnableScoutingFrames.getSelection();
        ByteBlowerPreferences.setEnableScoutingFrames((boolean)check);
        check = this.btnIgnoreInitializationErrors.getSelection();
        ByteBlowerPreferences.setIgnoreInitializationErrors((boolean)check);
        String waitTime = this.txtWaitTimeAfterScenario.getText();
        HighResolutionCalendar time = new HighResolutionCalendar();
        if (HighResolutionCalendarParser.setRelativeTime((String)waitTime, (HighResolutionCalendar)time)) {
            ByteBlowerPreferences.setWaitTimeAfterScenario((String)Long.toString(time.getTimeInNanoseconds()));
        }
        check = this.btnEnableAutomaticTcpRestart.getSelection();
        ByteBlowerPreferences.setEnableAutomaticTcpRestart((boolean)check);
        Long scenarioHeartbeatInterval = this.getScenarioHeartbeatInterval();
        ByteBlowerPreferences.setDefaultScenarioHeartbeatInterval((long)scenarioHeartbeatInterval);
    }

    private static final class HtmlLinkOpener
    extends SelectionAdapter {
        private final String helpArticle;

        public HtmlLinkOpener(String url) {
            this.helpArticle = url;
        }

        public void widgetSelected(SelectionEvent e) {
            Logger logger = Logger.getGlobal();
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(this.helpArticle));
            }
            catch (PartInitException ex) {
                logger.log(Level.WARNING, "Can not open Browser", ex);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, "Wrong url for help", ex);
            }
        }
    }
}

