/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SelectFlowTemplateDialog
extends TitleAreaDialog {
    private Button okButton;
    private FlowTemplate selectedFlowTemplate;
    private TableViewer tableViewer;
    private String shellText;
    private FlowTemplate initialFlowTemplate;
    private Combo comboFlowTemplateType;
    private Image dlgTitleImage = null;

    public SelectFlowTemplateDialog(Shell parentShell, String shellText, FlowTemplate initialFlowTemplate) {
        super(parentShell);
        this.shellText = shellText;
        this.initialFlowTemplate = initialFlowTemplate;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.shellText);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.setTitle(Messages.getString("SelectFlowTemplateDialog.info"));
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/FlowTemplate.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void filterTcp() {
        this.tableViewer.resetFilters();
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof TcpFlow;
            }
        });
    }

    private void filterFrameBlasting() {
        this.tableViewer.resetFilters();
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof FrameBlastingFlow;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Composite top = new Composite(composite, 0);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new GridLayout(2, false));
        Label type = new Label(top, 0);
        type.setText("Type:");
        this.comboFlowTemplateType = new Combo(top, 2056);
        this.comboFlowTemplateType.add(Messages.getString("SelectFlowTemplateDialog.tcp"));
        this.comboFlowTemplateType.add(Messages.getString("SelectFlowTemplateDialog.frameblasting"));
        Table table = new Table(composite, 2052);
        table.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(table);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public void notifyChanged(Notification notification) {
                int featureID;
                Object notifier = notification.getNotifier();
                if (notifier instanceof FlowTemplate) {
                    super.notifyChanged(notification);
                } else if (notifier instanceof ByteBlowerProject && (featureID = notification.getFeatureID(ByteBlowerProject.class)) == 8) {
                    super.notifyChanged(notification);
                }
            }

            public Object[] getElements(Object object) {
                ByteBlowerProject project = (ByteBlowerProject)object;
                return project.getFlowTemplate().toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        this.tableViewer.setInput((Object)project);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectFlowTemplateDialog.this.setDialogComplete(SelectFlowTemplateDialog.this.validatePage());
            }
        });
        this.comboFlowTemplateType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = SelectFlowTemplateDialog.this.comboFlowTemplateType.getSelectionIndex();
                if (i == 0) {
                    SelectFlowTemplateDialog.this.filterTcp();
                } else if (i == 1) {
                    SelectFlowTemplateDialog.this.filterFrameBlasting();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectFlowTemplateDialog.this.validatePage()) {
                    SelectFlowTemplateDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        return parentComposite;
    }

    public FlowTemplate getSelectedFlowTemplate() {
        return this.selectedFlowTemplate;
    }

    private void initializeControls() {
        if (this.initialFlowTemplate != null) {
            if (this.initialFlowTemplate instanceof TcpFlow) {
                this.filterTcp();
                this.comboFlowTemplateType.select(0);
            } else if (this.initialFlowTemplate instanceof FrameBlastingFlow) {
                this.filterFrameBlasting();
                this.comboFlowTemplateType.select(1);
            }
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialFlowTemplate));
        } else if (this.onlyFrameBlastingFlowTemplates()) {
            this.filterFrameBlasting();
            this.comboFlowTemplateType.select(1);
        } else {
            this.filterTcp();
            this.comboFlowTemplateType.select(0);
        }
        this.setDialogComplete(this.validatePage());
    }

    private boolean onlyFrameBlastingFlowTemplates() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        boolean tcp = false;
        boolean frameblasting = false;
        for (FlowTemplate flowTemplate : project.getFlowTemplate()) {
            if (flowTemplate instanceof TcpFlow) {
                tcp = true;
            } else if (flowTemplate instanceof FrameBlastingFlow) {
                frameblasting = true;
            }
            if (!tcp || !frameblasting) continue;
            return false;
        }
        return frameblasting && !tcp;
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            System.out.println("error : no flow template was selected");
            return;
        }
        this.selectedFlowTemplate = (FlowTemplate)selection.getFirstElement();
        this.close();
    }

    private void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    private boolean validatePage() {
        StructuredSelection selection;
        this.setErrorMessage(null);
        return this.tableViewer == null || (selection = (StructuredSelection)this.tableViewer.getSelection()).size() == 1;
    }
}

