/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import java.util.AbstractCollection;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectPortsDialog
extends TitleAreaDialog {
    private Button checkButton;
    private Button uncheckButton;
    private Collection<ByteBlowerGuiPort> tempByteBlowerPorts;
    private Collection<ByteBlowerGuiPort> initialCheckedPorts;
    private Collection<ByteBlowerGuiPort> initialSelectedPorts;
    private Collection<ByteBlowerGuiPort> checkedPorts;
    private String shellText;
    private TableViewer tableViewer;
    private Image dlgTitleImage = null;

    public SelectPortsDialog(Shell parentShell, String shellText, Collection<ByteBlowerGuiPort> tempByteBlowerPorts, Collection<ByteBlowerGuiPort> initialCheckedPorts, Collection<ByteBlowerGuiPort> initialSelectedPorts) {
        super(parentShell);
        this.shellText = shellText;
        this.tempByteBlowerPorts = tempByteBlowerPorts;
        this.initialCheckedPorts = initialCheckedPorts;
        this.initialSelectedPorts = initialSelectedPorts;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.shellText);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.setTitle(Messages.getString("SelectPortsDialog.info"));
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/SelectPorts.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Composite left = new Composite(parent, 0);
        left.setLayout((Layout)new GridLayout(2, true));
        this.checkButton = this.createButton(left, 2, "Check Selected", false);
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectPortsDialog.this.checkSelected(true);
            }
        });
        this.uncheckButton = this.createButton(left, 3, "Uncheck Selected", false);
        this.uncheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectPortsDialog.this.checkSelected(false);
            }
        });
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Table portTable = new Table(composite, 2082);
        portTable.setLayoutData((Object)new GridData(1808));
        Menu menu = this.createPopupMenu(parent);
        portTable.setMenu(menu);
        this.tableViewer = new TableViewer(portTable);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public void notifyChanged(Notification notification) {
                int featureID;
                Object notifier = notification.getNotifier();
                if (notifier instanceof ByteBlowerGuiPort) {
                    super.notifyChanged(notification);
                } else if (notifier instanceof ByteBlowerProject && (featureID = notification.getFeatureID(ByteBlowerProject.class)) == 10) {
                    super.notifyChanged(notification);
                }
            }

            public Object[] getElements(Object object) {
                AbstractCollection collection = (AbstractCollection)object;
                return collection.toArray();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectPortsDialog.this.enableOrDisableButtons();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.tableViewer.setInput(this.tempByteBlowerPorts);
        return parentComposite;
    }

    private void enableOrDisableButtons() {
        boolean enableCheck = false;
        boolean enableUncheck = false;
        TableItem[] sel = this.tableViewer.getTable().getSelection();
        int selPorts = sel.length;
        int i = 0;
        while (i < selPorts) {
            TableItem selectedItem = sel[i];
            if (selectedItem.getChecked()) {
                enableUncheck = true;
            } else {
                enableCheck = true;
            }
            ++i;
        }
        this.checkButton.setEnabled(enableCheck);
        this.uncheckButton.setEnabled(enableUncheck);
    }

    private Menu createPopupMenu(Composite parent) {
        Menu popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                boolean selectionEmpty = SelectPortsDialog.this.tableViewer.getSelection().isEmpty();
                boolean checkSelected = !selectionEmpty;
                boolean uncheckSelected = !selectionEmpty;
                items[0].setEnabled(checkSelected);
                items[1].setEnabled(uncheckSelected);
            }
        });
        MenuItem item = new MenuItem(popUpMenu, 8);
        item.setText("Check");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectPortsDialog.this.checkSelected(true);
            }
        });
        item = new MenuItem(popUpMenu, 8);
        item.setText("Uncheck");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectPortsDialog.this.checkSelected(false);
            }
        });
        return popUpMenu;
    }

    private void checkSelected(boolean check) {
        Table table = this.tableViewer.getTable();
        int[] selectionIndices = table.getSelectionIndices();
        int selectionSize = selectionIndices.length;
        int i = 0;
        while (i < selectionSize) {
            table.getItem(selectionIndices[i]).setChecked(check);
            ++i;
        }
        this.enableOrDisableButtons();
    }

    public Collection<ByteBlowerGuiPort> getCheckedByteBlowerGuiPorts() {
        return this.checkedPorts;
    }

    private void initializeControls() {
        ByteBlowerGuiPort port;
        int i;
        int nofPorts = this.tempByteBlowerPorts.size();
        Table table = this.tableViewer.getTable();
        if (this.initialCheckedPorts != null && !this.initialCheckedPorts.isEmpty()) {
            i = 0;
            while (i < nofPorts) {
                port = (ByteBlowerGuiPort)this.tableViewer.getElementAt(i);
                if (this.initialCheckedPorts.contains(port)) {
                    table.getItem(i).setChecked(true);
                }
                ++i;
            }
        }
        if (this.initialSelectedPorts != null && !this.initialSelectedPorts.isEmpty()) {
            i = 0;
            while (i < nofPorts) {
                port = (ByteBlowerGuiPort)this.tableViewer.getElementAt(i);
                if (this.initialSelectedPorts.contains(port)) {
                    table.select(i);
                }
                ++i;
            }
        }
        this.enableOrDisableButtons();
    }

    protected void okPressed() {
        this.checkedPorts = new BasicEList();
        int nofPorts = this.tempByteBlowerPorts.size();
        int i = 0;
        while (i < nofPorts) {
            ByteBlowerGuiPort port = (ByteBlowerGuiPort)this.tableViewer.getElementAt(i);
            if (this.tableViewer.getTable().getItem(i).getChecked()) {
                this.checkedPorts.add(port);
            }
            ++i;
        }
        this.close();
    }
}

