/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.IProjectProperties;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ThroughputPropertiesComposite
extends PropertiesComposite
implements IProjectProperties {
    protected IWorkbench workbench;
    private Button radioFrame;
    private Button radioFrameAndFCS;
    private Button radioFrameAndAllOtherFields;
    private Label info;
    private ThroughputType selectedType;

    public ThroughputPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    protected void createContents() {
        this.setLayoutData(new GridData(1808));
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        Label label = new Label((Composite)this, 0);
        label.setText("Choose what you want to be included in the Layer 2 Speed calculation for Frame Blasting (UDP Intended Load):");
        this.radioFrame = new Button((Composite)this, 16);
        this.radioFrame.setText("Frame");
        this.radioFrameAndFCS = new Button((Composite)this, 16);
        this.radioFrameAndFCS.setText("Frame and FCS");
        this.radioFrameAndAllOtherFields = new Button((Composite)this, 16);
        this.radioFrameAndAllOtherFields.setText("Frame, FCS, Preamble, SFD and Pause (= Physical Load)");
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout());
        group.setText("Info");
        this.info = new Label((Composite)group, 0);
        this.info.setLayoutData((Object)new GridData(1808));
        this.selectedType = currentProject != null ? currentProject.getThroughputType() : ThroughputType.get((int)ByteBlowerPreferences.getThroughputType());
        switch (this.selectedType.getValue()) {
            case 0: {
                this.radioFrame.setSelection(true);
                break;
            }
            case 1: {
                this.radioFrameAndFCS.setSelection(true);
                break;
            }
            case 2: {
                this.radioFrameAndAllOtherFields.setSelection(true);
            }
        }
        this.radioFrame.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ThroughputPropertiesComposite.this.radioFrame.getSelection()) {
                    ThroughputPropertiesComposite.this.selectedType = ThroughputType.FRAME_ONLY;
                    ThroughputPropertiesComposite.this.updateInfoText();
                }
            }
        });
        this.radioFrameAndFCS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ThroughputPropertiesComposite.this.radioFrameAndFCS.getSelection()) {
                    ThroughputPropertiesComposite.this.selectedType = ThroughputType.FRAME_AND_FCS;
                    ThroughputPropertiesComposite.this.updateInfoText();
                }
            }
        });
        this.radioFrameAndAllOtherFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ThroughputPropertiesComposite.this.radioFrameAndAllOtherFields.getSelection()) {
                    ThroughputPropertiesComposite.this.selectedType = ThroughputType.FRAME_AND_ALL_OTHER_FIELDS;
                    ThroughputPropertiesComposite.this.updateInfoText();
                }
            }
        });
        this.selectedType = currentProject == null ? ThroughputType.get((int)ByteBlowerPreferences.getThroughputType()) : currentProject.getThroughputType();
        switch (this.selectedType.getValue()) {
            case 0: {
                this.radioFrame.setSelection(true);
                break;
            }
            case 1: {
                this.radioFrameAndFCS.setSelection(true);
                break;
            }
            case 2: {
                this.radioFrameAndAllOtherFields.setSelection(true);
            }
        }
        this.updateInfoText();
    }

    private void updateInfoText() {
        String string = "These fields are used to calculate the Layer 2 Speed:\n\n\t-Frame\t\tas displayed in the Frame View\n";
        switch (this.selectedType.getValue()) {
            case 0: {
                string = String.valueOf(string) + "\nThis way, each Frame gets 0 bytes extra.";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "\t-FCS\t\tCRC Frame Checksum, 4 bytes\n\nThis way, each Frame gets 4 bytes extra.";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "\t-FCS\t\tCRC Frame Checksum, 4 bytes\n\t-Preamble\t7 bytes\n\t-SFD\t\tStart Frame Delimiter, 1 byte\n\t-Pause\t\t12 bytes\n\nThis way, each Frame gets 24 bytes extra.";
            }
        }
        this.info.setText(string);
        this.info.requestLayout();
    }

    @Override
    public void setAsDefault() {
        ByteBlowerPreferences.setThroughputType((int)this.selectedType.getValue());
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        if (currentProject.getThroughputType().equals((Object)this.selectedType)) {
            return;
        }
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setThroughputType(this.selectedType));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "Throughput project preferences", compCommCtlr.unwrap());
        operation.run();
        for (FlowTemplate flowTemplate : currentProject.getFlowTemplate()) {
            if (!(flowTemplate instanceof FrameBlastingFlow)) continue;
            FrameBlastingFlow frameBlastingFlow = (FrameBlastingFlow)flowTemplate;
            FrameBlastingFlowController controller = ControllerFactory.create((FrameBlastingFlow)frameBlastingFlow);
            controller.setStatusUnknown();
        }
    }
}

