/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.Ipv6AddressConfigType;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.Layer2Configuration;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ByteBlowerPortGroupController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv6ConfigurationController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.EthernetConfigurationReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.Ipv6ConfigurationReader;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.VlanStackReaderImpl;
import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.transfer.PhysicalConfigurationTransfer;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ByteBlowerGuiPortController
extends EByteBlowerObjectController<ByteBlowerGuiPort>
implements ByteBlowerGuiPortReader {
    private static final String VLAN_OPTION_NO = "NO_VLAN";
    public static final int MTU_MIN = 256;
    private static final String newPrefix = "PORT_";

    public ByteBlowerGuiPortController(ByteBlowerGuiPort myByteBlowerGuiPort) {
        super(myByteBlowerGuiPort);
    }

    private final Command checkAndSetNatCommand(boolean automaticNatDiscovery) {
        Command natCommand = this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__NATTED, automaticNatDiscovery);
        Command portForwardingCommand = this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__PORT_FORWARDING, null);
        CompoundCommandController controller = CompoundCommandController.createInstance();
        controller.appendCommand(natCommand);
        controller.appendCommand(portForwardingCommand);
        return controller.unwrap();
    }

    private final Command setNattedCommand(boolean newNatted) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__NATTED, newNatted);
    }

    public final CommandWithByteBlowerGuiPortReference copyNatted(ByteBlowerGuiPort referenceByteBlowerGuiPort) {
        ByteBlowerGuiPort newReferenceByteBlowerGuiPort = (ByteBlowerGuiPort)EByteBlowercoreUtil.copy((EObject)referenceByteBlowerGuiPort);
        Command newCommand = this.setNattedCommand(newReferenceByteBlowerGuiPort.isNatted());
        return new CommandWithByteBlowerGuiPortReference(newCommand, newReferenceByteBlowerGuiPort);
    }

    private static String getUniqueName(ByteBlowerProject byteblowerProject, ByteBlowerGuiPort port, String referenceName) {
        String newName = referenceName;
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)port, (String)newName)) {
            newName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)port, (String)newName, (String)newPrefix);
        }
        return newName;
    }

    static final ByteBlowerGuiPort create(ByteBlowerProject project, SupportedLayer3Configuration initialLayer3Configuration, String referenceName, MacAddressController referenceMac) {
        referenceMac = ByteBlowerGuiPortController.getUniqueMac(project, referenceMac);
        ByteBlowerGuiPort newObject = ByteBlowerGuiPortController.create(initialLayer3Configuration, referenceMac);
        String name = ByteBlowerGuiPortController.getUniqueName(project, newObject, referenceName);
        newObject.setName(name);
        return newObject;
    }

    private static MacAddressController getUniqueMac(ByteBlowerProject project, MacAddressController controller) {
        ByteBlowerProjectReader reader = ReaderFactory.create((ByteBlowerProject)project);
        List usedAddresses = reader.getAllMacAddresses();
        while (!ByteBlowerGuiPortController.isUnique(controller, usedAddresses)) {
            MacAddress incremented = controller.getIncrementedAddress();
            controller = ControllerFactory.create(incremented);
        }
        return controller;
    }

    private static boolean isUnique(MacAddressController controller, List<MacAddressReader> usedAddresses) {
        String address = controller.getAddress();
        for (MacAddressReader reader : usedAddresses) {
            if (!reader.getAddress().equals(address)) continue;
            return false;
        }
        return true;
    }

    private static ByteBlowerGuiPort create(SupportedLayer3Configuration initialLayer3Configuration, MacAddressController referenceMac) {
        ByteBlowerGuiPort byteblowerGuiPort = EByteBlowerObjectController.getByteblowerguimodelFactory().createByteBlowerGuiPort();
        Ipv4Configuration ipv4Config = Ipv4ConfigurationController.create();
        byteblowerGuiPort.setIpv4Configuration(ipv4Config);
        Ipv6Configuration ipv6Config = Ipv6ConfigurationController.create();
        byteblowerGuiPort.setIpv6Configuration(ipv6Config);
        switch (initialLayer3Configuration.getValue()) {
            case 0: {
                ipv4Config.setIsActive(Boolean.TRUE);
                break;
            }
            case 1: {
                ipv6Config.setIsActive(Boolean.TRUE);
                break;
            }
            default: {
                return null;
            }
        }
        EthernetConfiguration ethernetConfig = EthernetConfigurationController.create(referenceMac);
        byteblowerGuiPort.setLayer2Configuration((Layer2Configuration)ethernetConfig);
        ByteBlowerGuiPortConfiguration physicalConfiguration = ByteBlowerGuiPortConfigurationController.create();
        byteblowerGuiPort.setByteBlowerGuiPortConfiguration(physicalConfiguration);
        return byteblowerGuiPort;
    }

    public Command switchLayer3(SupportedLayer3Configuration toLayer3Configuration) {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            CompoundCommand compoundCommand = new CompoundCommand();
            CompoundCommandController compoundCommandController = new CompoundCommandController(compoundCommand);
            this.createIfNecessaryAndGet(toLayer3Configuration);
            if (myByteBlowerGuiPort.isSetIpv4Configuration()) {
                Ipv4ConfigurationController ipv4ConfigurationController = new Ipv4ConfigurationController(myByteBlowerGuiPort.getIpv4Configuration());
                compoundCommandController.appendCommand(ipv4ConfigurationController.setIsActive(toLayer3Configuration.equals((Object)SupportedLayer3Configuration.IPV4)));
            }
            if (myByteBlowerGuiPort.isSetIpv6Configuration()) {
                Ipv6ConfigurationController ipv6ConfigurationController = new Ipv6ConfigurationController(myByteBlowerGuiPort.getIpv6Configuration());
                compoundCommandController.appendCommand(ipv6ConfigurationController.setIsActive(toLayer3Configuration.equals((Object)SupportedLayer3Configuration.IPV6)));
            }
            return compoundCommand;
        }
        return null;
    }

    private void createIfNecessaryAndGet(SupportedLayer3Configuration supportedLayer3Configuration) {
        switch (supportedLayer3Configuration.getValue()) {
            case 0: {
                this.createIpv4ConfigurationIfNecessary();
                break;
            }
            case 1: {
                this.createIpv6ConfigurationIfNecessary();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void createIpv4ConfigurationIfNecessary() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            if (myByteBlowerGuiPort.isSetIpv4Configuration()) {
                return;
            }
            Ipv4Configuration ipv4Configuration = Ipv4ConfigurationController.create();
            myByteBlowerGuiPort.setIpv4Configuration(ipv4Configuration);
        }
    }

    private void createIpv6ConfigurationIfNecessary() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            if (myByteBlowerGuiPort.isSetIpv6Configuration()) {
                return;
            }
            Ipv6Configuration ipv6Configuration = Ipv6ConfigurationController.create();
            myByteBlowerGuiPort.setIpv6Configuration(ipv6Configuration);
        }
    }

    public final Ipv4Configuration getIpv4Configuration() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            return myByteBlowerGuiPort.getIpv4Configuration();
        }
        return null;
    }

    public final Ipv6Configuration getIpv6Configuration() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            return myByteBlowerGuiPort.getIpv6Configuration();
        }
        return null;
    }

    public final Ipv4ConfigurationController getIpv4ConfigurationController() {
        Ipv4Configuration myIpv4Configuration = this.getIpv4Configuration();
        if (myIpv4Configuration != null) {
            return new Ipv4ConfigurationController(myIpv4Configuration);
        }
        return null;
    }

    public final Ipv6ConfigurationController getIpv6ConfigurationController() {
        Ipv6Configuration myIpv6Configuration = this.getIpv6Configuration();
        if (myIpv6Configuration != null) {
            return new Ipv6ConfigurationController(myIpv6Configuration);
        }
        return null;
    }

    public final Command undock() {
        ByteBlowerGuiPortConfigurationController myByteBlowerGuiPortConfigurationController = this.getByteBlowerGuiPortConfigurationController();
        if (myByteBlowerGuiPortConfigurationController != null) {
            return myByteBlowerGuiPortConfigurationController.undock();
        }
        return null;
    }

    boolean hasPhysicalConfiguration(PhysicalConfigurationTransfer physicalConfigurationTransfer) {
        ByteBlowerGuiPortConfigurationController myByteBlowerGuiPortConfigurationController = this.getByteBlowerGuiPortConfigurationController();
        if (myByteBlowerGuiPortConfigurationController != null) {
            return myByteBlowerGuiPortConfigurationController.hasPhysicalConfiguration(physicalConfigurationTransfer);
        }
        return false;
    }

    public final Command setPhysicalConfiguration(PhysicalConfigurationTransfer physicalConfigurationTransfer) {
        ByteBlowerGuiPortConfigurationController myByteBlowerGuiPortConfigurationController = this.getByteBlowerGuiPortConfigurationController();
        if (myByteBlowerGuiPortConfigurationController != null) {
            return myByteBlowerGuiPortConfigurationController.setPhysicalConfiguration(physicalConfigurationTransfer);
        }
        return null;
    }

    public final synchronized PhysicalConfigurationTransfer getPhysicalConfigurationTransfer() {
        ByteBlowerGuiPortConfigurationController myByteBlowerGuiPortConfigurationController = this.getByteBlowerGuiPortConfigurationController();
        if (myByteBlowerGuiPortConfigurationController != null) {
            return myByteBlowerGuiPortConfigurationController.getPhysicalConfigurationTransfer();
        }
        return null;
    }

    public Dhcp getDhcpv4() {
        Dhcp dhcp = null;
        Ipv4Configuration ipv4Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration();
        if (ipv4Configuration != null) {
            dhcp = ipv4Configuration.getDhcpOptions();
        }
        return dhcp;
    }

    public Dhcp getDhcpv6() {
        Dhcp dhcp = null;
        Ipv6Configuration ipv6Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration();
        if (ipv6Configuration != null) {
            dhcp = ipv6Configuration.getDhcpOptions();
        }
        return dhcp;
    }

    public CommandWithVlanStackOptionReference clearVlanStack() {
        return new CommandWithVlanStackOptionReference(this.setVlanStackCommand(null), VLAN_OPTION_NO);
    }

    public boolean hasValidVlan() {
        return this.getVlanStack() != null;
    }

    public boolean usesOldDhcpv4() {
        boolean noDhcpRef;
        Ipv4Configuration ipv4Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration();
        if (ipv4Configuration == null) {
            return false;
        }
        boolean usesDhcp = ipv4Configuration.getAddressConfiguration() == Ipv4AddressConfigType.DHC_PV4;
        boolean bl = noDhcpRef = ipv4Configuration.getDhcpOptions() == null;
        return usesDhcp && noDhcpRef;
    }

    public boolean usesOldDhcpv6() {
        boolean noDhcpRef;
        Ipv6Configuration ipv6Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration();
        if (ipv6Configuration == null) {
            return false;
        }
        boolean usesDhcp = ipv6Configuration.getAddressConfiguration() == Ipv6AddressConfigType.DHC_PV6_LITERAL;
        boolean bl = noDhcpRef = ipv6Configuration.getDhcpOptions() == null;
        return usesDhcp && noDhcpRef;
    }

    public Command setMTU(Long value) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__MTU, value);
    }

    public Long getMTU() {
        return ((ByteBlowerGuiPort)this.getObject()).getMtu();
    }

    public CommandWithLongReference setMtu(Long mtu) {
        return new CommandWithLongReference(this.setMTU(mtu), mtu);
    }

    public CommandWithLongReference setIncrementedMtu(Long mtu, Long incrementValue) {
        Long incrementedMtu = mtu + incrementValue;
        return new CommandWithLongReference(this.setMTU(incrementedMtu), incrementedMtu);
    }

    public EthernetConfigurationController getEthernetConfigurationController() {
        EthernetConfiguration ethernetConfiguration = (EthernetConfiguration)((ByteBlowerGuiPort)this.getObject()).getLayer2Configuration();
        return new EthernetConfigurationController(ethernetConfiguration);
    }

    public final ByteBlowerGuiPortConfigurationController getByteBlowerGuiPortConfigurationController() {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration = this.getByteBlowerGuiPortConfiguration();
        if (myByteBlowerGuiPortConfiguration != null) {
            return new ByteBlowerGuiPortConfigurationController(myByteBlowerGuiPortConfiguration);
        }
        return null;
    }

    public CommandWithVlanStackOptionReference setIncrementedVlanStack(VlanStack vlanStack) {
        EByteBlowerObject nextObject;
        VlanStackReaderImpl reader = new VlanStackReaderImpl(vlanStack);
        if (vlanStack == null) {
            System.err.println("CommandWithVlanStackReference::setIncrementedVlanStack : vlan should never be null here !");
        }
        if ((nextObject = reader.getNextInContainer()) == null) {
            return null;
        }
        VlanStack incrementedVlanStack = (VlanStack)nextObject;
        return this.setVlanStack(incrementedVlanStack);
    }

    public CommandWithVlanStackOptionReference setVlanStack(Object vlanStack) {
        return new CommandWithVlanStackOptionReference(this.setVlanStackCommand(vlanStack), vlanStack);
    }

    public boolean hasActiveIpv4Configuration() {
        return ((ByteBlowerGuiPort)this.getObject()).isSetIpv4Configuration() && this.getIpv4Configuration().getIsActive() != false;
    }

    public boolean hasActiveIpv6Configuration() {
        return ((ByteBlowerGuiPort)this.getObject()).isSetIpv6Configuration() && this.getIpv6Configuration().getIsActive() != false;
    }

    public boolean isActiveLayer3Configuration(SupportedLayer3Configuration supportedLayer3Configuration) {
        if (supportedLayer3Configuration != null) {
            switch (supportedLayer3Configuration.getValue()) {
                case 0: {
                    return this.hasActiveIpv4Configuration();
                }
                case 1: {
                    return this.hasActiveIpv6Configuration();
                }
            }
        }
        return false;
    }

    private Command setNatConfig(PortForwarding portForwarding, boolean autoNat) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        Command setPortForwarding = this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__PORT_FORWARDING, portForwarding);
        Command enableNAT = this.setNattedCommand(portForwarding != null || autoNat);
        compound.appendCommand(setPortForwarding);
        compound.appendCommand(enableNAT);
        return compound.unwrap();
    }

    public Command setPortForwarding(PortForwarding portForwarding) {
        return this.setNatConfig(portForwarding, false);
    }

    public Command clearNat() {
        return this.setNatConfig(null, false);
    }

    public Command setNatAutomaticDiscovery() {
        return this.setNatConfig(null, true);
    }

    private ByteBlowerGuiPortReader getReader() {
        return ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)this.getObject()));
    }

    public ByteBlowerGuiPortConfigurationReader getByteBlowerGuiPortConfigurationReader() {
        return this.getReader().getByteBlowerGuiPortConfigurationReader();
    }

    public Ipv4ConfigurationReader getIpv4ConfigurationReader() {
        return this.getReader().getIpv4ConfigurationReader();
    }

    public Ipv6ConfigurationReader getIpv6ConfigurationReader() {
        return this.getReader().getIpv6ConfigurationReader();
    }

    public EthernetConfigurationReader getEthernetConfigurationReader() {
        return this.getReader().getEthernetConfigurationReader();
    }

    public String getVlanInfoForReport() {
        return this.getReader().getVlanInfoForReport();
    }

    public boolean isIPv4() {
        return this.getReader().isIPv4();
    }

    public boolean isIPv6() {
        return this.getReader().isIPv6();
    }

    public boolean isNatted() {
        return this.getReader().isNatted();
    }

    public String getMacAddressString() {
        return this.getReader().getMacAddressString();
    }

    public String getIPAddress() {
        return this.getReader().getIPAddress();
    }

    public String getDefaultIpv4Gateway() {
        return this.getReader().getDefaultIpv4Gateway();
    }

    public String getNetmask() {
        return this.getReader().getNetmask();
    }

    public String getDefaultIpv6Router() {
        return this.getReader().getDefaultIpv6Router();
    }

    public int getPrefixLength() {
        return this.getReader().getPrefixLength();
    }

    public String getPrefixLengthString() {
        return this.getReader().getPrefixLengthString();
    }

    public boolean usesDHCP() {
        return this.getReader().usesDHCP();
    }

    public boolean usesFixedIPConfiguration() {
        return this.getReader().usesFixedIPConfiguration();
    }

    public boolean usesStatelessAutoconfiguration() {
        return this.getReader().usesStatelessAutoconfiguration();
    }

    public boolean usesDeprecatedVlan() {
        return this.getReader().usesDeprecatedVlan();
    }

    public String getServerAddress() {
        return this.getReader().getServerAddress();
    }

    public long getMtuLong() {
        return this.getReader().getMtuLong();
    }

    public Integer getMtuInteger() {
        return this.getReader().getMtuInteger();
    }

    public ByteBlowerGuiPortConfiguration getByteBlowerGuiPortConfiguration() {
        return this.getReader().getByteBlowerGuiPortConfiguration();
    }

    public boolean hasActiveConfiguration() {
        return this.getReader().hasActiveConfiguration();
    }

    public Layer2Configuration getLayer2Configuration() {
        return this.getReader().getLayer2Configuration();
    }

    public boolean isAddressConfigurationSucceeded() {
        return this.getReader().isAddressConfigurationSucceeded();
    }

    public MacAddressReader getMacAddressReader() {
        return this.getReader().getMacAddressReader();
    }

    public String getDockedStatus() {
        return this.getReader().getDockedStatus();
    }

    public String getNatInfo() {
        return this.getReader().getNatInfo();
    }

    public VlanReader getVlanReader() {
        return this.getReader().getVlanReader();
    }

    public boolean isDocked() {
        return this.getReader().isDocked();
    }

    public boolean hasFixedAddress() {
        return this.getReader().hasFixedAddress();
    }

    public PortForwarding getPortForwarding() {
        return this.getReader().getPortForwarding();
    }

    public Boolean isNatAutoDiscovery() {
        return this.getReader().isNatAutoDiscovery();
    }

    public boolean usesPortForwarding() {
        return this.getReader().usesPortForwarding();
    }

    public Command unsetPortForwarding() {
        return this.setPortForwarding(null);
    }

    public Vlan getDeprecatedVlan() {
        return this.getReader().getDeprecatedVlan();
    }

    public Command setVlanStackCommand(Object vlanStack) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLANS, vlanStack);
    }

    public VlanStack getVlanStack() {
        return this.getReader().getVlanStack();
    }

    public VlanStackReader getVlanStackReader() {
        return this.getReader().getVlanStackReader();
    }

    public boolean hasValidVlanStack() {
        return this.getReader().hasValidVlanStack();
    }

    public String getVlanStackString() {
        return this.getReader().getVlanStackString();
    }

    public boolean usesVlanStack() {
        return this.getReader().usesVlanStack();
    }

    public boolean isDockedOnMobileDevice() {
        return this.getReader().isDockedOnMobileDevice();
    }

    public PhysicalDockableReader<?> getPhysicalDockableReader() {
        return this.getReader().getPhysicalDockableReader();
    }

    @Override
    public void createStatuses() {
        PhysicalDockableReader<?> dockable = this.getPhysicalDockableReader();
        boolean isDockedOnMobileDevice = this.isDockedOnMobileDevice();
        if (dockable == null) {
            this.addErrorStatus("Needs to be docked");
        } else {
            switch (dockable.getStatus()) {
                case 1: {
                    String server = dockable.getServer().getLocalName();
                    this.addErrorStatus(String.valueOf(server) + " needs refresh");
                    break;
                }
                case 2: {
                    this.addErrorStatus("Docking error");
                    break;
                }
            }
            if (isDockedOnMobileDevice && this.isIPv6()) {
                MobileDeviceReader reader = (MobileDeviceReader)dockable;
                String ipAddress = reader.getIpv6Address();
                if (!reader.hasCapability(CapabilityReader.TYPE.IPv6)) {
                    this.addErrorStatus("IPv6 isn't supported on this Wireless Endpoint version. Please update your device.");
                }
                if (ipAddress.isEmpty()) {
                    this.addErrorStatus("This Wireless Endpoint has no IPv6 address. Please check your network.");
                }
            }
        }
        if (!isDockedOnMobileDevice) {
            MacAddressReader macAddressReader = this.getMacAddressReader();
            if (!macAddressReader.isValid()) {
                this.addErrorStatus("MAC Address is invalid (" + macAddressReader.getAddress() + ")");
            }
            if (macAddressReader.isGroupAddress()) {
                this.addWarningStatus("Multicast or broadcast MAC Address. (" + macAddressReader.getAddress() + ") The least significant bit of the most significant byte is 1. Make the first byte even to fix this");
            }
            for (SupportedLayer3Configuration layer3 : this.getSupportedLayer3Types()) {
                if (layer3 == SupportedLayer3Configuration.IPV4) {
                    Ipv4ConfigurationReader ipv4 = this.getIpv4ConfigurationReader();
                    if (ipv4.usesDhcp() && ipv4.getDhcpOptions() == null) {
                        this.addErrorStatus("DHCP Configuration is missing");
                    }
                    if (!ipv4.usesFixedAdress()) continue;
                    if (!ipv4.getAddressReader().isValid(false)) {
                        this.addErrorStatus("IPv4 Address is invalid (" + ipv4.getAddressReader().getAddress() + ")");
                    }
                    if (!ipv4.getGatewayReader().isValid(false)) {
                        this.addErrorStatus("Default Gateway is invalid (" + ipv4.getGatewayReader().getAddress() + ")");
                    }
                    if (ipv4.getNetmaskReader().isValidNetmask()) continue;
                    this.addErrorStatus("Netmask is invalid (" + ipv4.getNetmaskReader().getAddress() + ")");
                    continue;
                }
                if (layer3 != SupportedLayer3Configuration.IPV6) continue;
                Ipv6ConfigurationReader ipv6 = this.getIpv6ConfigurationReader();
                if (ipv6.usesDHCP() && ipv6.getDhcpOptions() == null) {
                    this.addErrorStatus("DHCP Configuration is missing");
                }
                if (ipv6 == null || !ipv6.usesFixedAdress()) continue;
                if (!ipv6.getAddressReader().isValid(false)) {
                    this.addErrorStatus("IPv6 Address is invalid (" + ipv6.getAddressReader().getAddress() + ")");
                }
                if (ipv6.getDefaultRouterReader().isValid(false)) continue;
                this.addErrorStatus("Router Address is invalid (" + ipv6.getDefaultRouterReader().getAddress() + ")");
            }
        }
        if (this.hasPortForwarding()) {
            this.addDependingStatus("NAT", this.getPortForwardingReader());
        }
        if (this.hasVlanStack()) {
            this.addDependingStatus("VLAN Stack", (EByteBlowerObjectReader<?>)this.getVlanStackReader());
        }
    }

    public EByteBlowerObjectReader<?> getPortForwardingReader() {
        return this.getReader().getPortForwardingReader();
    }

    public boolean hasPortForwarding() {
        return this.getReader().hasPortForwarding();
    }

    public boolean hasVlanStack() {
        return this.getReader().hasVlanStack();
    }

    public MacAddressController getMacAddressController() {
        return ControllerFactory.create((MacAddress)this.getMacAddressReader().getObject());
    }

    public boolean hasDeletedDhcp() {
        return this.getReader().hasDeletedDhcp();
    }

    public FrameReader.Layer3Type getLayer3Type() {
        return this.getReader().getLayer3Type();
    }

    public boolean isDockingOk() {
        return this.getReader().isDockingOk();
    }

    public boolean matchesLayer3(List<SupportedLayer3Configuration> supportedTypes) {
        return this.getReader().matchesLayer3(supportedTypes);
    }

    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        return this.getReader().getSupportedLayer3Types();
    }

    public boolean isPartOfGroup() {
        return this.getReader().isPartOfGroup();
    }

    public ByteBlowerPortGroup getGroup() {
        return this.getReader().getGroup();
    }

    public ByteBlowerPortGroupController getGroupController() {
        return ControllerFactory.create(this.getGroup());
    }

    private final class CommandWithByteBlowerGuiPortReference
    extends CommandWithReference<ByteBlowerGuiPort> {
        private CommandWithByteBlowerGuiPortReference(Command myCommand, ByteBlowerGuiPort myByteBlowerGuiPortCommandReference) {
            super(myCommand, (Object)myByteBlowerGuiPortCommandReference);
        }
    }

    public final class CommandWithLongReference
    extends CommandWithReference<Long> {
        private CommandWithLongReference(Command command, Long longObject) {
            super(command, (Object)longObject);
        }
    }

    public final class CommandWithVlanStackOptionReference
    extends CommandWithReference<Object> {
        private CommandWithVlanStackOptionReference(Command command, Object vlanStackOption) {
            super(command, vlanStackOption);
        }
    }
}

