/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.edit.tools.UniquelyNamed;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ByteBlowerPortGroupController
extends EByteBlowerObjectController<ByteBlowerPortGroup>
implements ByteBlowerPortGroupReader,
UniquelyNamed {
    private ByteBlowerPortGroupReader reader;
    private static final String newGroupPrefix = "GROUP_";

    ByteBlowerPortGroupController(ByteBlowerPortGroup group) {
        super(group);
        this.reader = ReaderFactory.create((ByteBlowerPortGroup)group);
    }

    public List<ByteBlowerGuiPortReader> getPortReaders() {
        return this.reader.getPortReaders();
    }

    private static final ByteBlowerPortGroup create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createByteBlowerPortGroup();
    }

    protected static final ByteBlowerPortGroup create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newGroupName;
        ByteBlowerPortGroup newGroup = ByteBlowerPortGroupController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newGroup, (String)(newGroupName = referenceName))) {
            newGroupName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newGroup, (String)newGroupName, (String)newGroupPrefix);
        }
        newGroup.setName(newGroupName);
        return newGroup;
    }

    public Collection<String> takenNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ByteBlowerPortGroup pg : this.getProject().getPortGroup()) {
            result.add(pg.getName());
        }
        return result;
    }

    public Command addByteBlowerPort(ByteBlowerGuiPort byteBlowerGuiPort) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, byteBlowerGuiPort);
    }

    public Command addByteBlowerPorts(List<EByteBlowerObject> ports) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, ports);
    }

    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        return this.reader.getSupportedLayer3Types();
    }

    public boolean matchesLayer3(List<SupportedLayer3Configuration> supportedTypes) {
        return this.reader.matchesLayer3(supportedTypes);
    }

    public boolean hasActiveIpv4Configuration() {
        return this.reader.hasActiveIpv4Configuration();
    }

    public boolean hasActiveIpv6Configuration() {
        return this.reader.hasActiveIpv6Configuration();
    }

    public Command removeByteBlowerPorts(Collection<ByteBlowerGuiPort> ports) {
        return this.createRemoveCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, ports);
    }

    @Override
    public void createStatuses() {
        EList members = ((ByteBlowerPortGroup)this.getObject()).getMembers();
        if (members.isEmpty()) {
            this.addErrorStatus("Group is empty");
        } else {
            for (ByteBlowerGuiPort member : members) {
                ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)member);
                this.addDependingStatus("Group Member", (EByteBlowerObjectReader<?>)reader);
            }
            String otherAddress = null;
            String serverAddress = null;
            for (ByteBlowerGuiPort member : members) {
                ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)member);
                serverAddress = reader.getByteBlowerGuiPortConfigurationReader().getServerAddress();
                if (otherAddress == null) {
                    otherAddress = serverAddress;
                }
                if (serverAddress == null || otherAddress == null || serverAddress.compareTo(otherAddress) == 0) continue;
                this.addErrorStatus("All members must be docked on the same server");
                break;
            }
            VlanStack otherVlan = ((ByteBlowerGuiPort)members.get(0)).getVlans();
            for (ByteBlowerGuiPort member : members) {
                ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)member);
                VlanStack vlan = reader.getVlanStack();
                if (vlan == otherVlan) continue;
                this.addErrorStatus("All members must have the same VLAN stack");
                break;
            }
        }
    }
}

