/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.MultipleBurstReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.math.BigInteger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;

public final class FlowMeasurementController
extends EByteBlowerObjectController<FlowMeasurement>
implements FlowMeasurementReader {
    public FlowMeasurementController(FlowMeasurement myFlowMeasurement) {
        super(myFlowMeasurement);
    }

    static final FlowMeasurement create() {
        FlowMeasurement measurement = EByteBlowerObjectController.getByteblowerguimodelFactory().createFlowMeasurement();
        measurement.setFlowStartEvent(ScenarioFlowEventController.createStartEvent());
        measurement.setFlowStopEvent(ScenarioFlowEventController.createStopEvent());
        return measurement;
    }

    public Command setStartTime(HighResolutionCalendar startTime) {
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getObject();
        SetCommand cmd = new SetCommand(editingDomain, (EObject)flowMeasurement.getFlowStartEvent(), (EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO_EVENT__SCHEDULED_TIME, (Object)startTime);
        return cmd;
    }

    public Command delayStartTime(HighResolutionCalendar startTime) {
        CompoundCommandController strictCompound = CompoundCommandController.createStrictInstance((boolean)true);
        strictCompound.appendCommand(this.setStartTime(startTime));
        HighResolutionDuration duration = this.getDuration();
        if (duration != null) {
            HighResolutionCalendar newStopTime = startTime.addRelative((HighResolutionCalendar)duration);
            strictCompound.appendCommand(this.setStopTime(newStopTime));
        }
        return strictCompound.getCompoundCommand();
    }

    public Command setDuration(HighResolutionCalendar duration) {
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getObject();
        FlowMeasurementReaderImpl reader = new FlowMeasurementReaderImpl(flowMeasurement);
        HighResolutionCalendar startTime = reader.getStartTime();
        HighResolutionCalendar newStopTime = startTime.addRelative(duration);
        return new SetCommand(editingDomain, (EObject)flowMeasurement.getFlowStopEvent(), (EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO_EVENT__SCHEDULED_TIME, (Object)newStopTime);
    }

    public Command setStopTime(HighResolutionCalendar stoptime) {
        return new SetCommand(editingDomain, (EObject)((FlowMeasurement)this.getObject()).getFlowStopEvent(), (EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO_EVENT__SCHEDULED_TIME, (Object)stoptime);
    }

    public Command setNumberOfFrames(Long nofFrames) {
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getObject();
        Flow flow = flowMeasurement.getFlow();
        return this.setNumberOfFrames(flow, nofFrames);
    }

    private Command setNumberOfFrames(HighResolutionCalendar startTime, FrameBlastingFlow frameBlasting, Long nofFrames) {
        BigInteger overflowValue;
        BigInteger duration = null;
        BigInteger frameInterval = BigInteger.valueOf(frameBlasting.getFrameInterval().getTimeInNanoseconds());
        TimingModifier timing = frameBlasting.getTimingModifier();
        if (timing == null) {
            duration = frameInterval.multiply(BigInteger.valueOf(nofFrames));
        } else if (timing instanceof MultipleBurst) {
            MultipleBurst multipleBurst = (MultipleBurst)timing;
            MultipleBurstReader reader = ReaderFactory.create((MultipleBurst)multipleBurst);
            BigInteger nofFramesPerBurst = reader.getNofFramesPerBurstBigInteger();
            BigInteger interBurstGap = new BigInteger(multipleBurst.getInterBurstGap());
            BigInteger nofFramesBigInteger = BigInteger.valueOf(nofFrames);
            BigInteger nofInterBurstGaps = nofFramesBigInteger.divide(nofFramesPerBurst);
            BigInteger remainder = nofFramesBigInteger.remainder(nofFramesPerBurst);
            if (remainder.compareTo(BigInteger.ZERO) == 0) {
                nofInterBurstGaps = nofInterBurstGaps.subtract(BigInteger.ONE);
            }
            BigInteger totalBurstDuration = frameInterval.multiply(BigInteger.valueOf(nofFrames));
            BigInteger totalInterBurstDuration = nofInterBurstGaps.multiply(interBurstGap);
            duration = totalBurstDuration.add(totalInterBurstDuration);
        }
        if (startTime == null) {
            startTime = this.getStartTime();
        }
        if (duration.compareTo(overflowValue = BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            return null;
        }
        return this.setStopTime(startTime.addRelative(new HighResolutionCalendar(Long.valueOf(duration.longValue()))));
    }

    public HighResolutionCalendar getStartTime() {
        return this.getReader().getStartTime();
    }

    private FlowMeasurementReader getReader() {
        return ReaderFactory.create((FlowMeasurement)((FlowMeasurement)this.getObject()));
    }

    private Command setNumberOfFrames(Flow flow, Long nofFrames) {
        if (flow == null) {
            return null;
        }
        FlowTemplate flowTemplate = flow.getFlowTemplate();
        if (flowTemplate instanceof FrameBlastingFlow) {
            FrameBlastingFlow frameBlasting = (FrameBlastingFlow)flowTemplate;
            return this.setNumberOfFrames(frameBlasting, nofFrames);
        }
        return null;
    }

    private Command setNumberOfFrames(FrameBlastingFlow frameBlasting, Long nofFrames) {
        return this.setNumberOfFrames(null, frameBlasting, nofFrames);
    }

    public Command setFlow(Flow flow) {
        return this.createSetFlowCommand(flow);
    }

    private final Command createSetFlowCommand(Flow flow) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW, flow);
    }

    public HighResolutionDuration getDuration() {
        return this.getReader().getDuration();
    }

    public HighResolutionDuration getStopTime() {
        return this.getReader().getStopTime();
    }

    public Flow getFlow() {
        return this.getReader().getFlow();
    }

    public BigInteger getNumberOfFramesBigInteger() {
        return this.getReader().getNumberOfFramesBigInteger();
    }

    public HighResolutionCalendar getLastFrameTime() {
        return this.getReader().getLastFrameTime();
    }

    public FlowReader getFlowReader() {
        return this.getReader().getFlowReader();
    }

    public Long getStartTimeInNanoseconds() {
        return this.getReader().getStartTimeInNanoseconds();
    }

    public Long getDurationInNanoseconds() {
        return this.getReader().getDurationInNanoseconds();
    }

    public Long getStopTimeInNanoseconds() {
        return this.getReader().getStopTimeInNanoseconds();
    }

    public Long getNumberOfFrames() {
        return this.getReader().getNumberOfFrames();
    }

    public EList<ByteBlowerGuiPort> getInvolvedPorts() {
        return this.getReader().getInvolvedPorts();
    }

    public ByteBlowerGuiPort getSourcePort() {
        return this.getReader().getSourcePort();
    }

    public boolean hasDestinationPorts() {
        return this.getReader().hasDestinationPorts();
    }

    public EList<ByteBlowerGuiPort> getDestinationPorts() {
        return this.getReader().getDestinationPorts();
    }

    public boolean hasEavesdropperPorts() {
        return this.getReader().hasEavesdropperPorts();
    }

    public EList<ByteBlowerGuiPort> getEavesdropperPorts() {
        return this.getReader().getEavesdropperPorts();
    }

    public int getPositionInScenario() {
        return this.getReader().getPositionInScenario();
    }

    public boolean hasFixedEndTime() {
        return this.getReader().hasFixedEndTime();
    }

    public boolean isOverlapping() {
        return this.getReader().isOverlapping();
    }

    public Scenario getScenario() {
        return this.getReader().getScenario();
    }

    Command mimic(FlowMeasurementReader reader) {
        HighResolutionDuration stopTime;
        HighResolutionDuration myStopTime;
        Flow flow;
        Flow myFlow;
        HighResolutionCalendar startTime;
        CompoundCommandController mimicCompound = CompoundCommandController.createInstance();
        HighResolutionCalendar myStartTime = this.getStartTime();
        if (!myStartTime.equals((Object)(startTime = reader.getStartTime()))) {
            mimicCompound.appendCommand(this.setStartTime(startTime));
        }
        if ((myFlow = this.getFlow()) != (flow = reader.getFlow())) {
            mimicCompound.appendCommand(this.setFlow(flow));
        }
        if (!(myStopTime = this.getStopTime()).equals((Object)(stopTime = reader.getStopTime()))) {
            mimicCompound.appendCommand(this.setStopTime((HighResolutionCalendar)stopTime));
        }
        return mimicCompound.getCompoundCommand();
    }

    public boolean isFrameBlasting() {
        return this.getReader().isFrameBlasting();
    }

    public Long getByteCount() {
        return this.getReader().getByteCount();
    }

    public String getTos() {
        return this.getReader().getTos();
    }
}

