/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.Ipv6AddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.NetworkAddressController;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.Ipv6AddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;

public abstract class IpAddressController<IpAddressType extends IpAddress>
extends NetworkAddressController<IpAddressType> {
    private IpAddressReader<? extends IpAddress> reader = null;

    protected IpAddressController(IpAddressType myIpAddress) {
        super(myIpAddress);
    }

    public static boolean isValid(String string) {
        return Ipv4AddressController.isValid(string) || Ipv6AddressController.isValid(string);
    }

    public static boolean isValid(IpAddress address) {
        if (address instanceof Ipv4Address) {
            Ipv4AddressReader reader = ReaderFactory.create((Ipv4Address)((Ipv4Address)address));
            return reader.isValid();
        }
        Ipv6AddressReader reader = ReaderFactory.create((Ipv6Address)((Ipv6Address)address));
        return reader.isValid();
    }

    public static boolean isValidPartialInput(String string) {
        return Ipv4AddressController.isValidPartialInput(string) || Ipv6AddressController.isValidPartialInput(string);
    }

    public static boolean isValid(NetworkAddressBytes networkAddressBytes) {
        return Ipv4AddressController.isValid(networkAddressBytes) || Ipv6AddressController.isValid(networkAddressBytes);
    }

    public static IpAddress createFromString(String string) {
        if (Ipv4AddressController.isValid(string)) {
            Ipv4Address ipv4 = Ipv4AddressController.createEmptyIpv4Address();
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(ipv4);
            ipv4AddressController.setAddress(string);
            return ipv4;
        }
        if (Ipv6AddressController.isValid(string)) {
            Ipv6Address ipv6 = Ipv6AddressController.createEmptyIpv6Address();
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(ipv6);
            ipv6AddressController.setAddress(string);
            return ipv6;
        }
        return null;
    }

    public static NetworkAddressBytes createBytesFromString(String string) throws IllegalArgumentException {
        if (Ipv4AddressController.isValid(string)) {
            return Ipv4AddressController.createBytesFromString(string);
        }
        if (Ipv6AddressController.isValid(string)) {
            return Ipv6AddressController.createBytesFromString(string);
        }
        throw new IllegalArgumentException("Failed to parse IP address from String.");
    }

    public static IpAddress createFromBytes(NetworkAddressBytes networkAddressBytes) throws IllegalArgumentException {
        if (networkAddressBytes.size() == 4) {
            Ipv4Address ipv4 = Ipv4AddressController.createEmptyIpv4Address();
            Ipv4AddressController controller = ControllerFactory.create(ipv4);
            controller.setAddress(networkAddressBytes).execute();
            return ipv4;
        }
        if (networkAddressBytes.size() == 16) {
            Ipv6Address ipv6 = Ipv6AddressController.createEmptyIpv6Address();
            Ipv6AddressController controller = ControllerFactory.create(ipv6);
            controller.setAddress(networkAddressBytes).execute();
            return ipv6;
        }
        throw new IllegalArgumentException("Failed to parse IP address from network bytes.");
    }

    public boolean isValidValue(NetworkAddressBytes networkAddressBytes) {
        IpAddress myIpAddress = (IpAddress)this.getObject();
        if (myIpAddress != null) {
            EList myIpAddressValue = myIpAddress.getBytes();
            return myIpAddressValue != null && networkAddressBytes.size() == myIpAddressValue.size();
        }
        return false;
    }

    public abstract String getMulticastMacAddressString();

    public String getAddress() {
        return this.getReader().getAddress();
    }

    private IpAddressReader<? extends IpAddress> getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((IpAddress)((IpAddress)this.getObject()));
        }
        return this.reader;
    }

    public static Object[] copyIpAddresses(Collection<IpAddress> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (IpAddress object : objects) {
            IpAddress copy = (IpAddress)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        IpAddress[] array = (IpAddress[])copiedObjects.toArray((Object[])new IpAddress[objects.size()]);
        return new Object[]{array};
    }

    public boolean isIPv4() {
        return this.getReader().isIPv4();
    }

    public IpAddress getIncrementedAddress() {
        return (IpAddress)this.getReader().getIncrementedAddress();
    }
}

