/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.NetworkAddress;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.Layer3ConfigurationController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.NetworkAddressController;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.impl.DhcpReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.Ipv4ConfigurationReaderImpl;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class Ipv4ConfigurationController
extends Layer3ConfigurationController<Ipv4Configuration>
implements Ipv4ConfigurationReader {
    public Ipv4ConfigurationController(Ipv4Configuration myIpv4Configuration) {
        super(myIpv4Configuration);
    }

    public final Command setFixedAddressConfiguration() {
        return this.setAddressConfiguration(Ipv4AddressConfigType.FIXED, null);
    }

    private final Command setAddressConfiguration(Ipv4AddressConfigType newIpv4AddressConfigType, Dhcp dhcp) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV4_CONFIGURATION__ADDRESS_CONFIGURATION, newIpv4AddressConfigType));
        compound.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV4_CONFIGURATION__DHCP_OPTIONS, dhcp));
        return compound.getCompoundCommand();
    }

    public final CommandWithIpv4ConfigurationReference copyAddressConfiguration(Ipv4Configuration referenceIpv4Configuration) {
        Command newCommand = this.setAddressConfiguration(referenceIpv4Configuration.getAddressConfiguration(), referenceIpv4Configuration.getDhcpOptions());
        return new CommandWithIpv4ConfigurationReference(newCommand, referenceIpv4Configuration);
    }

    public final CommandWithDhcpv4OptionReference setIncrementedAddressConfiguration(Dhcp referenceDhcp) {
        DhcpReaderImpl reader = new DhcpReaderImpl(referenceDhcp);
        Dhcp nextDhcp = (Dhcp)reader.getNextInContainer();
        if (nextDhcp == null) {
            return null;
        }
        Command newCommand = this.setAddressConfiguration(Ipv4AddressConfigType.DHC_PV4, nextDhcp);
        return new CommandWithDhcpv4OptionReference(newCommand, nextDhcp);
    }

    public final Command setIpAddress(NetworkAddressBytes newIpAddress) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getIpAddress());
            return ipv4AddressController.setAddress(newIpAddress);
        }
        return null;
    }

    public final Command setIpAddress(Ipv4Address newIpAddress) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV4_CONFIGURATION__IP_ADDRESS, newIpAddress);
    }

    public final CommandWithIpv4ConfigurationReference copyIpAddress(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getIpAddress());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.copyAddress(newReferenceIpv4Configuration.getIpAddress());
            newReferenceIpv4Configuration.setIpAddress((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setIncrementedIpAddress(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getIpAddress());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setIncrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getIpAddress());
            newReferenceIpv4Configuration.setIpAddress((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setDecrementedIpAddress(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getIpAddress());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setDecrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getIpAddress());
            newReferenceIpv4Configuration.setIpAddress((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final Command setDefaultGateway(NetworkAddressBytes newDefaultGateway) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getDefaultGateway());
            return ipv4AddressController.setAddress(newDefaultGateway);
        }
        return null;
    }

    public final Command setDefaultGateway(Ipv4Address newDefaultGateway) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV4_CONFIGURATION__DEFAULT_GATEWAY, newDefaultGateway);
    }

    public final CommandWithIpv4ConfigurationReference copyDefaultGateway(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getDefaultGateway());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.copyAddress(newReferenceIpv4Configuration.getDefaultGateway());
            newReferenceIpv4Configuration.setDefaultGateway((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setDecrementedDefaultGateway(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getDefaultGateway());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setDecrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getDefaultGateway());
            newReferenceIpv4Configuration.setDefaultGateway((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setIncrementedDefaultGateway(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getDefaultGateway());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setIncrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getDefaultGateway());
            newReferenceIpv4Configuration.setDefaultGateway((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final Command setNetmask(NetworkAddressBytes newNetmask) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getNetmask());
            return ipv4AddressController.setAddress(newNetmask);
        }
        return null;
    }

    public final Command setNetmask(Ipv4Address newNetmask) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV4_CONFIGURATION__NETMASK, newNetmask);
    }

    public final CommandWithIpv4ConfigurationReference copyNetmask(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getNetmask());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.copyAddress(newReferenceIpv4Configuration.getNetmask());
            newReferenceIpv4Configuration.setNetmask((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setDecrementedNetmask(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getNetmask());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setDecrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getNetmask());
            newReferenceIpv4Configuration.setNetmask((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    public final CommandWithIpv4ConfigurationReference setIncrementedNetmask(Ipv4Configuration referenceIpv4Configuration) {
        Ipv4Configuration myIpv4Configuration = (Ipv4Configuration)this.getObject();
        if (myIpv4Configuration != null) {
            Ipv4AddressController ipv4AddressController = ControllerFactory.create(myIpv4Configuration.getNetmask());
            Ipv4Configuration newReferenceIpv4Configuration = (Ipv4Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv4Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv4AddressController.setIncrementedAddress((NetworkAddress)newReferenceIpv4Configuration.getNetmask());
            newReferenceIpv4Configuration.setNetmask((Ipv4Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv4ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv4Configuration);
        }
        return null;
    }

    protected static final Ipv4Configuration create() {
        Ipv4Configuration ipv4Configuration = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv4Configuration();
        Ipv4Address ipv4Address = Ipv4AddressController.create();
        ipv4Configuration.setIpAddress(ipv4Address);
        ipv4Address = Ipv4AddressController.create();
        ipv4Configuration.setDefaultGateway(ipv4Address);
        ipv4Address = Ipv4AddressController.createNetmask();
        ipv4Configuration.setNetmask(ipv4Address);
        return ipv4Configuration;
    }

    public CommandWithDhcpv4OptionReference setDhcp(Dhcp newDhcp) {
        Ipv4AddressConfigType type = newDhcp == null ? Ipv4AddressConfigType.FIXED : Ipv4AddressConfigType.DHC_PV4;
        Command command = this.setAddressConfiguration(type, newDhcp);
        return new CommandWithDhcpv4OptionReference(command, newDhcp);
    }

    public Ipv4Configuration getIpv4Configuration() {
        return (Ipv4Configuration)this.getObject();
    }

    private Ipv4ConfigurationReader getReader() {
        return new Ipv4ConfigurationReaderImpl(this.getIpv4Configuration());
    }

    public Ipv4AddressReader getAddressReader() {
        return this.getReader().getAddressReader();
    }

    public Ipv4AddressReader getGatewayReader() {
        return this.getReader().getGatewayReader();
    }

    public Ipv4AddressReader getNetmaskReader() {
        return this.getReader().getNetmaskReader();
    }

    public Ipv4AddressController getAddressController() {
        return ControllerFactory.create((Ipv4Address)this.getAddressReader().getObject());
    }

    public Ipv4AddressController getGatewayController() {
        return ControllerFactory.create((Ipv4Address)this.getGatewayReader().getObject());
    }

    public Ipv4AddressController getNetmaskController() {
        return ControllerFactory.create((Ipv4Address)this.getNetmaskReader().getObject());
    }

    public boolean usesFixedAdress() {
        return this.getReader().usesFixedAdress();
    }

    public Ipv4AddressConfigType getConfigurationType() {
        return this.getReader().getConfigurationType();
    }

    public boolean usesDhcp() {
        return this.getReader().usesDhcp();
    }

    public Dhcp getDhcpOptions() {
        return this.getReader().getDhcpOptions();
    }

    public final class CommandWithDhcpv4OptionReference
    extends CommandWithReference<Object> {
        private CommandWithDhcpv4OptionReference(Command command, Object dhcpOption) {
            super(command, dhcpOption);
        }
    }

    public final class CommandWithIpv4ConfigurationReference
    extends CommandWithReference<Ipv4Configuration> {
        private CommandWithIpv4ConfigurationReference(Command myCommand, Ipv4Configuration myIpv4ConfigurationCommandReference) {
            super(myCommand, (Object)myIpv4ConfigurationCommandReference);
        }
    }
}

