/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.Ipv6AddressConfigType;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.Ipv6AddressController;
import com.excentis.products.byteblower.model.control.Layer3ConfigurationController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.NetworkAddressController;
import com.excentis.products.byteblower.model.reader.impl.DhcpReaderImpl;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class Ipv6ConfigurationController
extends Layer3ConfigurationController<Ipv6Configuration> {
    public Ipv6ConfigurationController(Ipv6Configuration myIpv6Configuration) {
        super(myIpv6Configuration);
    }

    public final Command setAddressConfiguration(Ipv6AddressConfigType newIpv6AddressConfigType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__ADDRESS_CONFIGURATION, newIpv6AddressConfigType);
    }

    public final CommandWithIpv6ConfigurationReference copyAddressConfiguration(Ipv6Configuration referenceIpv6Configuration) {
        Command newCommand = this.setAddressConfigurationCommand(referenceIpv6Configuration.getAddressConfiguration(), referenceIpv6Configuration.getDhcpOptions());
        return new CommandWithIpv6ConfigurationReference(newCommand, referenceIpv6Configuration);
    }

    public final Command setIpAddress(NetworkAddressBytes newIpAddress) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getIpAddress());
            return ipv6AddressController.setAddress(newIpAddress);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference copyIpAddress(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getIpAddress());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.copyAddress(newReferenceIpv6Configuration.getIpAddress());
            newReferenceIpv6Configuration.setIpAddress((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference setIncrementedIpAddress(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getIpAddress());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.setIncrementedAddress(newReferenceIpv6Configuration.getIpAddress());
            newReferenceIpv6Configuration.setIpAddress((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference setDecrementedIpAddress(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getIpAddress());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.setDecrementedAddress(newReferenceIpv6Configuration.getIpAddress());
            newReferenceIpv6Configuration.setIpAddress((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final Command setDefaultRouter(NetworkAddressBytes newDefaultRouter) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getDefaultRouter());
            return ipv6AddressController.setAddress(newDefaultRouter);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference copyDefaultRouter(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getDefaultRouter());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.copyAddress(newReferenceIpv6Configuration.getDefaultRouter());
            newReferenceIpv6Configuration.setDefaultRouter((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference setDecrementedDefaultRouter(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getDefaultRouter());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.setDecrementedAddress(newReferenceIpv6Configuration.getDefaultRouter());
            newReferenceIpv6Configuration.setDefaultRouter((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final CommandWithIpv6ConfigurationReference setIncrementedDefaultRouter(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration myIpv6Configuration = (Ipv6Configuration)this.getObject();
        if (myIpv6Configuration != null) {
            Ipv6AddressController ipv6AddressController = ControllerFactory.create(myIpv6Configuration.getDefaultRouter());
            Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
            NetworkAddressController.CommandWithNetworkAddressReference commandWithNetworkAddressReference = ipv6AddressController.setIncrementedAddress(newReferenceIpv6Configuration.getDefaultRouter());
            newReferenceIpv6Configuration.setDefaultRouter((Ipv6Address)commandWithNetworkAddressReference.getCommandReference());
            return new CommandWithIpv6ConfigurationReference(commandWithNetworkAddressReference.getCommand(), newReferenceIpv6Configuration);
        }
        return null;
    }

    public final Command setPrefixLength(Integer newPrefixLength) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__PREFIX_LENGTH, newPrefixLength);
    }

    private final Command setPrefixLengthCommand(Integer newPrefixLength) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__PREFIX_LENGTH, newPrefixLength);
    }

    public final CommandWithIpv6ConfigurationReference copyPrefixLength(Ipv6Configuration referenceIpv6Configuration) {
        Ipv6Configuration newReferenceIpv6Configuration = (Ipv6Configuration)EByteBlowercoreUtil.copy((EObject)referenceIpv6Configuration);
        Command newCommand = this.setPrefixLengthCommand(newReferenceIpv6Configuration.getPrefixLength());
        return new CommandWithIpv6ConfigurationReference(newCommand, newReferenceIpv6Configuration);
    }

    protected static final Ipv6Configuration create() {
        Ipv6Configuration ipv6Config = EByteBlowerObjectController.getByteblowerguimodelFactory().createIpv6Configuration();
        Ipv6Address address = Ipv6AddressController.create();
        ipv6Config.setIpAddress(address);
        Ipv6Address router = Ipv6AddressController.create();
        ipv6Config.setDefaultRouter(router);
        ipv6Config.setPrefixLength(new Integer(64));
        return ipv6Config;
    }

    public final Command setFixed() {
        return this.setAddressConfiguration(Ipv6AddressConfigType.FIXED_LITERAL, null);
    }

    public final Command setAuto() {
        return this.setAddressConfiguration(Ipv6AddressConfigType.AUTO_CONFIGURATION_LITERAL, null);
    }

    public final Command setDhcpv6(Dhcp dhcp) {
        return this.setAddressConfiguration(Ipv6AddressConfigType.DHC_PV6_LITERAL, dhcp);
    }

    public CommandWithDhcpv6OptionReference setDhcp(Dhcp newDhcp) {
        Command command = this.setDhcpv6(newDhcp);
        return new CommandWithDhcpv6OptionReference(command, newDhcp);
    }

    public CommandWithDhcpv6OptionReference setIncrementedDhcp(Dhcp previousDhcp) {
        DhcpReaderImpl reader = new DhcpReaderImpl(previousDhcp);
        Dhcp nextDhcp = (Dhcp)reader.getNextInContainer();
        if (nextDhcp == null) {
            return null;
        }
        Command newCommand = this.setAddressConfigurationCommand(Ipv6AddressConfigType.DHC_PV6_LITERAL, nextDhcp);
        return new CommandWithDhcpv6OptionReference(newCommand, nextDhcp);
    }

    private final Command setAddressConfiguration(Ipv6AddressConfigType newIpv6AddressConfigType, Dhcp dhcp) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__ADDRESS_CONFIGURATION, newIpv6AddressConfigType));
        compound.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__DHCP_OPTIONS, dhcp));
        return compound.unwrap();
    }

    private final Command setAddressConfigurationCommand(Ipv6AddressConfigType newIpv6AddressConfigType, Dhcp dhcp) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__ADDRESS_CONFIGURATION, newIpv6AddressConfigType));
        compound.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.IPV6_CONFIGURATION__DHCP_OPTIONS, dhcp));
        return compound.unwrap();
    }

    public final class CommandWithDhcpv6OptionReference
    extends CommandWithReference<Object> {
        private CommandWithDhcpv6OptionReference(Command command, Object dhcpOption) {
            super(command, dhcpOption);
        }
    }

    private final class CommandWithIpv6ConfigurationReference
    extends CommandWithReference<Ipv6Configuration> {
        private CommandWithIpv6ConfigurationReference(Command myCommand, Ipv6Configuration myIpv6ConfigurationCommandReference) {
            super(myCommand, (Object)myIpv6ConfigurationCommandReference);
        }
    }
}

