/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.NetworkAddressController;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.NetworkAddressReader;
import com.excentis.products.byteblower.model.reader.impl.MacAddressReaderImpl;
import com.excentis.products.byteblower.object.control.ByteCollectionController;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public final class MacAddressController
extends NetworkAddressController<MacAddress>
implements MacAddressReader {
    private static final String MacAddressPart = "([0-9a-fA-F]{2,2})";
    private static final String AllowedMacAddressSeparators = ":.-";
    private static final String AllowedMacAddressSeparatorsRegex = "[:.-]";
    private static final String CompleteMacAddress = "^([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})$";
    private static final String MacAddressShortPart = "([0-9a-fA-F]{1,2})";
    private static final String ShortCompleteMacAddress = "^([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})$";
    private static Byte random = null;

    public MacAddressController(MacAddress myMacAddress) {
        super(myMacAddress);
    }

    @Override
    protected final int getNetworkAddressSize() {
        return 6;
    }

    private static final String unifyMacAddress(String macAddress) throws NumberFormatException {
        return NetworkAddressController.unifyNetworkAddress(macAddress, AllowedMacAddressSeparators, MacAddressReaderImpl.UnifiedMacAddressSeparator.charValue());
    }

    @Override
    public final void setAddress(String newAddress) throws NumberFormatException {
        this.setAddress(MacAddressController.unifyMacAddress(newAddress), '-');
    }

    static MacAddressController createDefaultMacAddress() {
        MacAddress mac = MacAddressController.getByteblowerguimodelFactory().createMacAddress();
        MacAddressController controller = ControllerFactory.create(mac);
        controller.setAddress("00-FF-BB-00-00-01");
        controller.setRandomByte(3);
        return controller;
    }

    public void setRandomByte(int i) {
        this.setByte(i, this.getRandomByte());
    }

    private byte getRandomByte() {
        if (random == null) {
            byte[] b = new byte[1];
            new Random().nextBytes(b);
            random = b[0];
        }
        return random;
    }

    private void setByte(int i, byte b) {
        ((MacAddress)this.getObject()).getBytes().remove(i);
        ((MacAddress)this.getObject()).getBytes().add(i, (Object)b);
    }

    public static MacAddressController createFromString(String string) throws IllegalArgumentException {
        if (MacAddressReaderImpl.isValid((String)string)) {
            MacAddressController controller = MacAddressController.createDefaultMacAddress();
            controller.setAddress(string);
            return controller;
        }
        throw new IllegalArgumentException("Failed to parse MAC address from String.");
    }

    public static NetworkAddressBytes createBytesFromString(String string) throws IllegalArgumentException {
        if (MacAddressReaderImpl.isValid((String)string)) {
            NetworkAddressBytes newByteList = new NetworkAddressBytes();
            ByteCollectionController byteCollectionController = new ByteCollectionController((List)((Object)newByteList));
            byteCollectionController.fromByteString(MacAddressController.unifyMacAddress(string), '-', false, 6);
            return newByteList;
        }
        throw new IllegalArgumentException("Failed to parse MAC address from String.");
    }

    public MacAddressReader getReader() {
        return new MacAddressReaderImpl((MacAddress)this.getObject());
    }

    public String getAddress() {
        return this.getReader().getAddress();
    }

    public static final boolean isComplete(String macAddress) {
        return Pattern.matches(CompleteMacAddress, macAddress);
    }

    public boolean isValid() {
        return this.getReader().isValid();
    }

    public boolean isValid(boolean allowZero) {
        return this.getReader().isValid(allowZero);
    }

    public MacAddress getIncrementedAddress() {
        return (MacAddress)this.getReader().getIncrementedAddress();
    }

    public boolean isZero() {
        return this.getReader().isZero();
    }

    public boolean isGroupAddress() {
        return this.getReader().isGroupAddress();
    }

    public MacAddressController getIncrementedAddressController() {
        return ControllerFactory.create(this.getIncrementedAddress());
    }

    public int compareTo(NetworkAddressReader<?> address) {
        return this.getReader().compareTo(address);
    }
}

