/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.MulticastSourceByteBlowerGuiPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.MulticastSourceMemberPortController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.MulticastSourceGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MulticastSourceGroupController
extends EByteBlowerObjectController<MulticastSourceGroup>
implements MulticastSourceGroupReader {
    private static final String newMulticastSourceGroupPrefix = "MULTICAST_SOURCE_";
    private MulticastSourceGroupReader reader;

    MulticastSourceGroupController(MulticastSourceGroup multicastSourceGroup) {
        super(multicastSourceGroup);
    }

    private static final MulticastSourceGroup create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createMulticastSourceGroup();
    }

    protected static final MulticastSourceGroup create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newMulticastSourceGroupName;
        MulticastSourceGroup newMulticastSourceGroup = MulticastSourceGroupController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newMulticastSourceGroup, (String)(newMulticastSourceGroupName = referenceName))) {
            newMulticastSourceGroupName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newMulticastSourceGroup, (String)newMulticastSourceGroupName, (String)newMulticastSourceGroupPrefix);
        }
        newMulticastSourceGroup.setName(newMulticastSourceGroupName);
        return newMulticastSourceGroup;
    }

    private final Command createAddIpAddressCommand(IpAddress ipAddress) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddress);
    }

    public final CommandWithIpAddressListReference addIpAddress(int amount, int index) {
        MulticastSourceGroup myObject = (MulticastSourceGroup)this.getObject();
        if (amount > 0 && myObject != null) {
            Command addCommand;
            UniqueEList controllers = new UniqueEList();
            if (amount == 1) {
                Ipv4Address newObject = this.createIpv4Address();
                controllers.add((Object)ControllerFactory.create(newObject));
                addCommand = index == -1 ? this.createAddCommand((IpAddress)newObject) : this.createAddCommand((IpAddress)newObject, index);
            } else {
                UniqueEList newObjects = new UniqueEList();
                int i = 0;
                while (i < amount) {
                    Ipv4Address newObject = this.createIpv4Address();
                    newObjects.add(newObject);
                    controllers.add((Object)ControllerFactory.create(newObject));
                    ++i;
                }
                addCommand = index == -1 ? this.createAddIpAddressesCommand((Collection<IpAddress>)newObjects) : this.createAddIpAddressesCommand((Collection<IpAddress>)newObjects, index);
            }
            return new CommandWithIpAddressListReference(addCommand, (List<IpAddressController<?>>)controllers);
        }
        return null;
    }

    private Ipv4Address createIpv4Address() {
        Ipv4Address result = Ipv4AddressController.create();
        return result;
    }

    private final Command createAddIpAddressCommand(Collection<IpAddress> ipAddresses) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddresses);
    }

    private final Command createAddIpAddressCommand(IpAddress ipAddress, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddress, index);
    }

    private final Command createAddIpAddressCommand(Collection<IpAddress> ipAddresses, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddresses, index);
    }

    private final Command createRemoveIpAddressCommand(IpAddress ipAddress) {
        EList multicastSourceIpAddresses;
        MulticastSourceGroup myMulticastSourceGroup = (MulticastSourceGroup)this.getObject();
        if (myMulticastSourceGroup != null && (multicastSourceIpAddresses = myMulticastSourceGroup.getIpAddresses()).contains((Object)ipAddress)) {
            return MulticastSourceGroupController.createDeleteCommand(ipAddress);
        }
        return null;
    }

    private Command createUpdateIpAddressCommand(IpAddress oldIpAddress, IpAddress newIpAddress, int newIndex) {
        Command addCommand;
        Command removeCommand = this.createRemoveIpAddressCommand(oldIpAddress);
        if (removeCommand != null && (addCommand = this.createAddIpAddressCommand(newIpAddress, newIndex)) != null) {
            CompoundCommand newCommand = new CompoundCommand();
            newCommand.append(removeCommand);
            newCommand.append(addCommand);
            return newCommand;
        }
        return null;
    }

    public final Command setIpAddress(IpAddress oldIpAddress, NetworkAddressBytes newValue) throws IllegalArgumentException {
        EList multicastSourceIpAddresses;
        int index;
        MulticastSourceGroup myMulticastSourceGroup = (MulticastSourceGroup)this.getObject();
        if (myMulticastSourceGroup != null && (index = (multicastSourceIpAddresses = myMulticastSourceGroup.getIpAddresses()).indexOf((Object)oldIpAddress)) >= 0) {
            IpAddressController<? extends IpAddress> ipAddressController = ControllerFactory.create(oldIpAddress);
            if (ipAddressController.isValidValue(newValue)) {
                return ipAddressController.setAddress(newValue);
            }
            IpAddress newIpAddress = IpAddressController.createFromBytes(newValue);
            return this.createUpdateIpAddressCommand(oldIpAddress, newIpAddress, index);
        }
        return null;
    }

    private final Command createAddCommand(IpAddress ipAddress) {
        return this.createAddCommand(ipAddress, -1);
    }

    private final Command createAddCommand(IpAddress ipAddress, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddress, index);
    }

    private final Command createAddIpAddressesCommand(Collection<IpAddress> ipAddressses) {
        return this.createAddIpAddressesCommand(ipAddressses, -1);
    }

    private final Command createAddIpAddressesCommand(Collection<IpAddress> ipAddressses, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__IP_ADDRESSES, ipAddressses, index);
    }

    private final Command createAddCommand(MulticastSourceByteBlowerGuiPort multicastSourceMember, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__MULTICAST_SOURCE_BYTE_BLOWER_GUI_PORT, multicastSourceMember, index);
    }

    private final Command createAddCommand(Collection<MulticastSourceByteBlowerGuiPort> multicastSourceMembers) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__MULTICAST_SOURCE_BYTE_BLOWER_GUI_PORT, multicastSourceMembers);
    }

    private final Command createAddCommand(Collection<MulticastSourceByteBlowerGuiPort> multicastSourceMembers, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_SOURCE_GROUP__MULTICAST_SOURCE_BYTE_BLOWER_GUI_PORT, multicastSourceMembers, index);
    }

    public CommandWithIpAddressListReference pasteIpAddresses(IpAddress[] copiedObjects, int pastePos) {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        BasicEList pastedObjectControllers = new BasicEList();
        BasicEList pastedObjects = new BasicEList();
        if (copiedObjects != null) {
            IpAddress[] ipAddressArray = copiedObjects;
            int n = copiedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                IpAddress copiedObject = ipAddressArray[n2];
                IpAddress duplicate = (IpAddress)EByteBlowercoreUtil.copy((EObject)copiedObject, (boolean)true);
                if (duplicate != null) {
                    IpAddressController<? extends IpAddress> controller = ControllerFactory.create(duplicate);
                    pastedObjects.add((Object)duplicate);
                    pastedObjectControllers.add(controller);
                }
                ++n2;
            }
            compoundCommandController.appendCommand(this.createAddIpAddressCommand((Collection<IpAddress>)pastedObjects, pastePos));
        }
        return new CommandWithIpAddressListReference(compoundCommandController.unwrap(), (List<IpAddressController<?>>)pastedObjectControllers);
    }

    public Object[] copyMulticastMemberPorts(UniqueEList<MulticastSourceByteBlowerGuiPort> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (MulticastSourceByteBlowerGuiPort object : objects) {
            MulticastSourceByteBlowerGuiPort copy = (MulticastSourceByteBlowerGuiPort)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        MulticastSourceByteBlowerGuiPort[] array = (MulticastSourceByteBlowerGuiPort[])copiedObjects.toArray((Object[])new MulticastSourceByteBlowerGuiPort[objects.size()]);
        return new Object[]{array};
    }

    public CommandWithMulticastSourceMemberListReference pasteMulticastMemberPorts(MulticastSourceByteBlowerGuiPort[] copiedObjects, int pastePos) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        CompoundCommand referenceSetCompound = new CompoundCommand();
        BasicEList pastedObjectControllers = new BasicEList();
        BasicEList pastedObjects = new BasicEList();
        if (copiedObjects != null) {
            MulticastSourceByteBlowerGuiPort duplicate = null;
            MulticastSourceByteBlowerGuiPort[] multicastSourceByteBlowerGuiPortArray = copiedObjects;
            int n = copiedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                MulticastSourceByteBlowerGuiPort copiedObject = multicastSourceByteBlowerGuiPortArray[n2];
                if (!this.usesByteBlowerGuiPort(copiedObject.getByteBlowerGuiPort()) && (duplicate = (MulticastSourceByteBlowerGuiPort)this.duplicate(referenceSetCompound, (EByteBlowerObject)copiedObject)) != null) {
                    MulticastSourceMemberPortController controller = ControllerFactory.create(duplicate);
                    pastedObjects.add((Object)duplicate);
                    pastedObjectControllers.add(controller);
                }
                ++n2;
            }
            compound.appendCommand(this.createAddCommand((Collection<MulticastSourceByteBlowerGuiPort>)pastedObjects, pastePos));
            compound.appendCommand((Command)referenceSetCompound);
        }
        return new CommandWithMulticastSourceMemberListReference(compound.unwrap(), (List<MulticastSourceMemberPortController>)pastedObjectControllers);
    }

    public boolean usesByteBlowerGuiPort(ByteBlowerGuiPort byteBlowerGuiPort) {
        return this.getReader().usesByteBlowerGuiPort(byteBlowerGuiPort);
    }

    private MulticastSourceGroupReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((MulticastSourceGroup)((MulticastSourceGroup)this.getObject()));
        }
        return this.reader;
    }

    public List<ByteBlowerGuiPort> getPorts() {
        return this.getReader().getPorts();
    }

    public List<String> getIpAddressStrings() {
        return this.getReader().getIpAddressStrings();
    }

    public boolean containsIpv6() {
        return this.getReader().containsIpv6();
    }

    public boolean containsIpv4() {
        return this.getReader().containsIpv4();
    }

    public EList<IpAddress> getIpAddresses() {
        return this.getReader().getIpAddresses();
    }

    public EList<MulticastSourceByteBlowerGuiPort> getMulticastSourceByteBlowerGuiPorts() {
        return this.getReader().getMulticastSourceByteBlowerGuiPorts();
    }

    public Command addIpAddress(IpAddress ipAddress, int index) {
        return this.createAddIpAddressCommand(ipAddress, index);
    }

    @Override
    public void createStatuses() {
        EList<IpAddress> ipAddresses = this.getIpAddresses();
        boolean containsIpv4 = this.containsIpv4();
        boolean containsIpv6 = this.containsIpv6();
        if (!containsIpv4 && !containsIpv6) {
            this.addWarningStatus("Is empty");
        } else if (containsIpv4 && containsIpv6) {
            this.addErrorStatus("Contains a mix of IPv4 and IPv6");
        } else {
            IpAddressReader reader;
            for (IpAddress msIpAddress : ipAddresses) {
                reader = ReaderFactory.create((IpAddress)msIpAddress);
                if (reader.isValid(false)) continue;
                this.addErrorStatus("Contains invalid IP Addresses");
                break;
            }
            for (MulticastSourceByteBlowerGuiPort msPort : this.getMulticastSourceByteBlowerGuiPorts()) {
                reader = ReaderFactory.create((ByteBlowerGuiPort)msPort.getByteBlowerGuiPort());
                if (!reader.hasError()) continue;
                this.addErrorStatus("Contains invalid ByteBlower Ports");
                break;
            }
        }
    }

    public static final class CommandWithIpAddressListReference
    extends CommandWithListReference<IpAddressController<?>> {
        private CommandWithIpAddressListReference(Command myCommand, List<IpAddressController<?>> myCommandReference) {
            super(myCommand, myCommandReference);
        }
    }

    public static final class CommandWithMulticastSourceMemberListReference
    extends CommandWithListReference<MulticastSourceMemberPortController> {
        private CommandWithMulticastSourceMemberListReference(Command myCommand, List<MulticastSourceMemberPortController> myMulticastSourceMemberListCommandReference) {
            super(myCommand, myMulticastSourceMemberListCommandReference);
        }
    }
}

