/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

final class UnicastController
extends EByteBlowerObjectController<Unicast> {
    UnicastController(Unicast myUnicast) {
        super(myUnicast);
    }

    private final EReference getIpAddressEReference() {
        return ByteblowerguimodelPackage.Literals.UNICAST__IP_ADDRESS;
    }

    private final Command createSetIpAddressCommand(IpAddress newIpAddress) {
        return this.createSetCommand((EStructuralFeature)this.getIpAddressEReference(), newIpAddress);
    }

    private final Command setIpAddress(NetworkAddressBytes newUnicastIpAddress) {
        Unicast myUnicast = (Unicast)this.getObject();
        if (myUnicast != null) {
            IpAddress newIpAddress;
            IpAddressController<? extends IpAddress> ipAddressController = ControllerFactory.create(myUnicast.getIpAddress());
            if (ipAddressController.isValidValue(newUnicastIpAddress)) {
                return ipAddressController.setAddress(newUnicastIpAddress);
            }
            try {
                newIpAddress = IpAddressController.createFromBytes(newUnicastIpAddress);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return this.createSetIpAddressCommand(newIpAddress);
        }
        return null;
    }

    final Command setIpAddress(String newUnicastIpAddress) {
        NetworkAddressBytes newNetworkAddressBytes;
        try {
            newNetworkAddressBytes = IpAddressController.createBytesFromString(newUnicastIpAddress);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.setIpAddress(newNetworkAddressBytes);
    }

    static final Unicast createFromString(String newUnicastAddress) {
        Unicast unicast = EByteBlowerObjectController.getByteblowerguimodelFactory().createUnicast();
        IpAddress ipAddress = IpAddressController.createFromString(newUnicastAddress);
        unicast.setIpAddress(ipAddress);
        return unicast;
    }
}

