/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class VlanController
extends EByteBlowerObjectController<Vlan> {
    private static final String newPrefix = "VLAN_";

    VlanController(Vlan myVlan) {
        super(myVlan);
    }

    private static final Vlan create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createVlan();
    }

    public static final Vlan create(ByteBlowerProject byteblowerProject) {
        return VlanController.create(byteblowerProject, null);
    }

    public static final Vlan create(ByteBlowerProject byteblowerProject, String referenceVlanName) {
        String newVlanName;
        Vlan newVlan = VlanController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newVlan, (String)(newVlanName = referenceVlanName))) {
            newVlanName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newVlan, (String)newVlanName, (String)newPrefix);
        }
        newVlan.setName(newVlanName);
        newVlan.setProtocolId(33024);
        return newVlan;
    }

    public Command setDropEligible(boolean dropEligible) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__DROP_ELIGIBLE, dropEligible);
        return setCommand;
    }

    public Command setPriorityCodePoint(byte priorityCodePoint) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PRIORITY_CODE_POINT, priorityCodePoint);
        return setCommand;
    }

    public Command setVlanId(short vlanId) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__VLAN_ID, vlanId);
        return setCommand;
    }

    public Command setProtocolId(int protocolId) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PROTOCOL_ID, protocolId);
        return setCommand;
    }
}

