/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.IpAddressItemProvider;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.impl.Ipv4AddressReaderImpl;
import com.excentis.products.byteblower.object.control.ByteCollectionController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.graphics.Color;

public class Ipv4AddressItemProvider
extends IpAddressItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    private static final int COLUMN_NAME = 0;

    public Ipv4AddressItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Ipv4Address"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    private String getAddress(Ipv4Address ipv4Address) throws NumberFormatException {
        ByteCollectionController byteCollectionController = new ByteCollectionController((List)ipv4Address.getBytes());
        return byteCollectionController.toByteString(Character.valueOf('.'), 1, true);
    }

    @Override
    public String getText(Object object) {
        if (object instanceof Ipv4Address) {
            return this.getAddress((Ipv4Address)object);
        }
        return "";
    }

    public Object getColumnImage(Object object, int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(object);
            }
        }
        return "";
    }

    @Override
    public Color getBackground(Object element, int columnIndex) {
        return EByteBlowerObjectItemProvider.BACKGROUND_COLOR_NONE;
    }

    public Color getForeground(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Ipv4AddressReader reader = this.getIpv4AddressReader((Ipv4Address)element);
                if (reader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private Ipv4AddressReader getIpv4AddressReader(Ipv4Address object) {
        return new Ipv4AddressReaderImpl(object);
    }
}

