/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.TcpFlowGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.provider.ProtocolFlowItemProvider;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class TcpFlowItemProvider
extends ProtocolFlowItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final String[] scaleValueChoices = new String[]{"0 (multiply with 1)", "1 (multiply with 2)", "2 (multiply with 4)", "3 (multiply with 8)", "4 (multiply with 16)", "5 (multiply with 32)", "6 (multiply with 64)", "7 (multiply with 128)", "8 (multiply with 256)", "9 (multiply with 512)", "10 (multiply with 1024)", "11 (multiply with 2048)", "12 (multiply with 4096)"};
    public static final int COLUMN_TCPFLOW_NAME = 0;
    public static final int COLUMN_TCPFLOW_DURATION = 1;
    public static final int COLUMN_TCPFLOW_RATE_LIMIT = 2;
    public static final int COLUMN_TCPFLOW_INITIALRECEIVEWINDOW = 3;
    public static final int COLUMN_TCPFLOW_WINDOWSCALING = 4;
    public static final int COLUMN_TCPFLOW_RCVWINDOWSCALE = 5;
    public static final int COLUMN_TCPFLOW_SLOWSTART = 6;
    public static final int COLUMN_TCPFLOW_HTTPMETHOD = 7;
    public static final int COLUMN_TCPFLOW_L4S = 8;
    public static final int COLUMN_TCPFLOW_TCPCAA = 9;
    public static final int COLUMN_TCPFLOW_CLIENTPORT = 10;
    public static final int COLUMN_TCPFLOW_SERVERPORT = 11;

    public TcpFlowItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPayloadSizePropertyDescriptor(object);
            this.addWindowSizePropertyDescriptor(object);
            this.addWindowScalingPropertyDescriptor(object);
            this.addL4sPropertyDescriptor(object);
            this.addRcvWindowScalePropertyDescriptor(object);
            this.addClientPortPropertyDescriptor(object);
            this.addHTTPMethodPropertyDescriptor(object);
            this.addTCPCongestionAvoidanceAlgorithmPropertyDescriptor(object);
            this.addServerPortPropertyDescriptor(object);
            this.addRateLimitPropertyDescriptor(object);
            this.addRateLimitUnitPropertyDescriptor(object);
            this.addPayloadUnitPropertyDescriptor(object);
            this.addSlowStartPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPayloadSizePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_payloadSize_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_payloadSize_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_SIZE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addWindowSizePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_windowSize_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_windowSize_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SIZE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addWindowScalingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_windowScaling_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_windowScaling_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SCALING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addL4sPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_l4s_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_l4s_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__L4S, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addRcvWindowScalePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_rcvWindowScale_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_rcvWindowScale_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RCV_WINDOW_SCALE, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addClientPortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_clientPort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_clientPort_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__CLIENT_PORT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addHTTPMethodPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_HTTPMethod_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_HTTPMethod_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__HTTP_METHOD, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTCPCongestionAvoidanceAlgorithmPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_TCPCongestionAvoidanceAlgorithm_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_TCPCongestionAvoidanceAlgorithm_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__TCP_CONGESTION_AVOIDANCE_ALGORITHM, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addServerPortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_serverPort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_serverPort_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__SERVER_PORT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRateLimitPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_rateLimit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_rateLimit_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addRateLimitUnitPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_rateLimitUnit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_rateLimitUnit_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT_UNIT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPayloadUnitPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_payloadUnit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_payloadUnit_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_UNIT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addSlowStartPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TcpFlow_slowStart_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TcpFlow_slowStart_feature", "_UI_TcpFlow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__SLOW_START, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TcpFlow"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TcpFlow.class)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public String getText(Object object) {
        String label = ((TcpFlow)object).getName();
        return label == null || label.length() == 0 ? "" : label;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        TcpFlow tcpFlowTemplate = (TcpFlow)object;
        TcpFlowReader reader = ReaderFactory.create((TcpFlow)tcpFlowTemplate);
        String returnString = "";
        switch (columnIndex) {
            case 0: {
                returnString = reader.getName();
                break;
            }
            case 1: {
                returnString = reader.getPayloadSizeString();
                break;
            }
            case 2: {
                returnString = reader.getRateLimitString();
                break;
            }
            case 3: {
                returnString = reader.getWindowSizeString();
                break;
            }
            case 4: {
                returnString = reader.isWindowScalingString();
                break;
            }
            case 5: {
                returnString = scaleValueChoices[reader.getRcvWindowScale()];
                break;
            }
            case 6: {
                returnString = reader.getSlowStartString();
                break;
            }
            case 7: {
                returnString = reader.getHTTPMethodString();
                break;
            }
            case 8: {
                returnString = reader.isL4SString();
                break;
            }
            case 9: {
                returnString = reader.getTCPCongestionAvoidanceAlgorithmString();
                break;
            }
            case 10: {
                returnString = reader.getClientPortString();
                break;
            }
            case 11: {
                returnString = reader.getServerPortString();
                break;
            }
        }
        return returnString;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                TcpFlowGuiReader reader = GuiReaderFactory.create((TcpFlow)((TcpFlow)object));
                return reader.getImage();
            }
        }
        return null;
    }

    @Override
    public Color getBackground(Object element, int columnIndex) {
        TcpFlow tcp = (TcpFlow)element;
        ByteBlowerProject project = tcp.getByteBlowerProject();
        if (project != null) {
            UniqueEList tcpFlowTemplates = new UniqueEList();
            for (FlowTemplate template : project.getFlowTemplate()) {
                if (!(template instanceof TcpFlow)) continue;
                tcpFlowTemplates.add((Object)((TcpFlow)template));
            }
            int index = tcpFlowTemplates.indexOf((Object)tcp);
            return index % 2 == 0 ? EByteBlowerObjectItemProvider.BACKGROUND_COLOR_EVEN_ROW : EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ODD_ROW();
        }
        return EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ERROR;
    }

    public Color getForeground(Object element, int columnIndex) {
        TcpFlow tcpFlow = (TcpFlow)element;
        TcpFlowReader reader = ReaderFactory.create((TcpFlow)tcpFlow);
        switch (columnIndex) {
            case 1: {
                if (!reader.hasInvalidPayloadSize()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(2, (EStructuralFeature)ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME);
            }
            case 1: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_SIZE);
            }
            case 2: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT);
            }
            case 3: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SIZE);
            }
            case 4: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SCALING);
            }
            case 5: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RCV_WINDOW_SCALE);
            }
            case 6: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__SLOW_START);
            }
            case 7: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__HTTP_METHOD);
            }
            case 8: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__L4S);
            }
            case 9: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__TCP_CONGESTION_AVOIDANCE_ALGORITHM);
            }
            case 10: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__CLIENT_PORT);
            }
            case 11: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__SERVER_PORT);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }
}

