/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.utils.Utils;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class VlanItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int COLUMN_VLAN_PROTOCOL_ID = 0;
    public static final int COLUMN_VLAN_IDENTIFIER = 1;
    public static final int COLUMN_VLAN_PRIORITY_CODE_POINT = 2;
    public static final int COLUMN_VLAN_DROP_ELIGIBLE = 3;

    public VlanItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPriorityCodePointPropertyDescriptor(object);
            this.addDropEligiblePropertyDescriptor(object);
            this.addVlanIdPropertyDescriptor(object);
            this.addVlanStackPartsPropertyDescriptor(object);
            this.addProtocolIdPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPriorityCodePointPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Vlan_PriorityCodePoint_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Vlan_PriorityCodePoint_feature", "_UI_Vlan_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PRIORITY_CODE_POINT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addDropEligiblePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Vlan_DropEligible_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Vlan_DropEligible_feature", "_UI_Vlan_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__DROP_ELIGIBLE, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addVlanIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Vlan_VlanId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Vlan_VlanId_feature", "_UI_Vlan_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__VLAN_ID, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addVlanStackPartsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Vlan_vlanStackParts_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Vlan_vlanStackParts_feature", "_UI_Vlan_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__VLAN_STACK_PARTS, true, false, true, null, null, null));
    }

    protected void addProtocolIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Vlan_ProtocolId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Vlan_ProtocolId_feature", "_UI_Vlan_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PROTOCOL_ID, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Vlan"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String label = ((Vlan)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_Vlan_type") : String.valueOf(this.getString("_UI_Vlan_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Vlan.class)) {
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        Vlan vlan = (Vlan)object;
        String returnString = "";
        VlanReader reader = ReaderFactory.create((Vlan)vlan);
        switch (columnIndex) {
            case 0: {
                returnString = "0x" + Utils.int2HexString((int)reader.getProtocolId());
                String extraInfo = reader.getProtocolIdInfo();
                if (extraInfo.isEmpty()) break;
                returnString = String.valueOf(returnString) + " (" + extraInfo + ")";
                break;
            }
            case 2: {
                returnString = Byte.toString(vlan.getPriorityCodePoint());
                break;
            }
            case 3: {
                returnString = Utils.bool2string((boolean)vlan.isDropEligible());
                break;
            }
            case 1: {
                returnString = Short.toString(vlan.getVlanId());
                if (reader.isOuter()) {
                    returnString = String.valueOf(returnString) + " (Outer)";
                    break;
                }
                if (!reader.isInner()) break;
                returnString = String.valueOf(returnString) + " (Inner)";
            }
        }
        return returnString;
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PROTOCOL_ID);
            }
            case 1: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__VLAN_ID);
            }
            case 2: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__PRIORITY_CODE_POINT);
            }
            case 3: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN__DROP_ELIGIBLE);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }

    @Override
    public Color getAlternatingBackground(EByteBlowerObject eByteBlowerObject) {
        VlanStackReader stackReader;
        EList vlans;
        int index;
        VlanStack stack;
        Vlan vlan = (Vlan)eByteBlowerObject;
        VlanReader reader = ReaderFactory.create((Vlan)vlan);
        if (reader.isContained() && (stack = reader.getVlanStack()) != null && (index = (vlans = (stackReader = ReaderFactory.create((VlanStack)stack)).getVlans()).indexOf((Object)vlan)) % 2 == 0) {
            return ByteBlowerColor.lightBlue;
        }
        return null;
    }
}

