/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader;

import com.excentis.products.byteblower.model.BenchmarkFrame;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.reader.FlowTemplateReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface FrameBlastingBenchmarkReader
extends FlowTemplateReader<FrameBlastingBenchmark> {
    public static final long WAIT_BETWEEN_ITERATIONS = 3000000000L;
    public static final int ITERATION_COUNT = 23;
    public static final HighResolutionDuration MINIMUM_ITERATION_DURATION = new HighResolutionDuration(Long.valueOf(TimeUnit.SECONDS.toNanos(3L)));

    public List<BenchmarkFrame> getBenchmarkFrames();

    public int getNofBenchmarkFrames();

    @Override
    public String getName();

    public HighResolutionDuration getEstimatedDuration();

    public HighResolutionCalendar getIterationDuration();

    public HighResolutionDuration getEstimatedDuration(HighResolutionCalendar var1);

    public HighResolutionDuration getIterationDuration(HighResolutionCalendar var1);

    public static HighResolutionDuration getEstimatedDuration(HighResolutionCalendar iterationDuration, int nofFrameSizes) {
        if (iterationDuration == null || nofFrameSizes == 0) {
            return new HighResolutionDuration(Long.valueOf(0L));
        }
        long singleStepNanos = iterationDuration.getTimeInNanoseconds();
        long total = (singleStepNanos + 3000000000L) * 23L * (long)nofFrameSizes;
        return new HighResolutionDuration(Long.valueOf(total), true);
    }

    public static HighResolutionDuration getIterationDuration(HighResolutionCalendar totalDuration, int nofFrameSizes) {
        if (totalDuration == null || nofFrameSizes == 0) {
            return new HighResolutionDuration(Long.valueOf(0L));
        }
        long totalNanos = totalDuration.getTimeInNanoseconds();
        long singleStepNanos = totalNanos / (long)(nofFrameSizes * 23) - 3000000000L;
        return new HighResolutionDuration(Long.valueOf(Math.max(0L, singleStepNanos)), true);
    }
}

