/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader;

import com.excentis.products.byteblower.frame.ARPPacket;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameFieldModifier;
import com.excentis.products.byteblower.model.FrameL3Type;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;

public interface FrameReader
extends EByteBlowerObjectReader<Frame> {
    public FrameL3Type getEthernetType();

    public Layer3Type getLayer3Type();

    public Layer4Type getLayer4Type();

    public int getL4Type();

    public byte[] getBytes();

    public ARPPacket getArp();

    public EthernetPacket getEthernet();

    public Ipv4Packet getIpv4();

    public Ipv6Packet getIpv6();

    public UDPPacket getCurrentUdp();

    public TCPPacket getCurrentTcp();

    public byte[] getBuffer();

    public String getHexBytes();

    public Frame getFrame();

    public int getByteSize(ThroughputType var1);

    public int getBitSize(ThroughputType var1);

    @Override
    public String getName();

    public boolean hasFrameModifiers();

    public FrameFieldModifier getFrameFieldModifier();

    public EList<FrameModifier> getModifiers();

    public Byte getTosByte();

    public static enum Layer3Type {
        UNKNOWN,
        ARP,
        IPV4,
        IPV6;

        private Collection<Layer3Type> compatibleFormat = new ArrayList<Layer3Type>();

        static {
            Layer3Type.ARP.compatibleFormat.add(IPV4);
            Layer3Type.IPV4.compatibleFormat.add(ARP);
        }

        private Layer3Type() {
            this.compatibleFormat.add(this);
        }

        public boolean isCompatible(Layer3Type other) {
            return this.compatibleFormat.contains((Object)other);
        }
    }

    public static enum Layer4Type {
        UNKNOWN,
        TCP,
        UDP;

    }
}

