/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.BatchActionBlockReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import org.eclipse.emf.common.util.EList;

public class BatchActionReaderImpl
extends EByteBlowerObjectReaderImpl<BatchAction>
implements BatchActionReader {
    public BatchActionReaderImpl(BatchAction batchAction) {
        super(batchAction);
    }

    @Override
    public boolean isContained() {
        Batch batch;
        BatchActionBlock batchActionBlock;
        BatchAction myBatchAction = (BatchAction)this.getObject();
        return myBatchAction != null && (batchActionBlock = myBatchAction.getBatchActionBlock()) != null && (batch = batchActionBlock.getBatch()) != null;
    }

    public Batch getBatch() {
        BatchActionBlock batchActionBlock;
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null && (batchActionBlock = myBatchAction.getBatchActionBlock()) != null) {
            return batchActionBlock.getBatch();
        }
        return null;
    }

    @Override
    public BatchActionBlock getBatchActionBlock() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getBatchActionBlock();
        }
        return null;
    }

    @Override
    public final HighResolutionCalendar getStartTime() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getStartTime();
        }
        return null;
    }

    private boolean isValidRelativeStartTimeString(String relativeStartTimeString) {
        return HighResolutionCalendarParser.relativeTimeInputPatternMatches((String)relativeStartTimeString);
    }

    @Override
    public final TimedStartType getStartType() {
        BatchActionBlockReaderImpl blockReader;
        EList<BatchAction> batchActions;
        BatchActionBlock batchActionBlock = this.getBatchActionBlock();
        if (batchActionBlock != null && (batchActions = (blockReader = new BatchActionBlockReaderImpl(batchActionBlock)).getBatchActions()) != null) {
            int batchActionIndex = batchActions.indexOf(this.getObject());
            if (batchActionIndex > 0) {
                return TimedStartType.RELATIVE;
            }
            if (batchActionIndex == 0) {
                return blockReader.getStartType();
            }
        }
        return TIMED_START_TYPE_UNKNOWN;
    }

    @Override
    public final Scenario getScenario() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getScenario();
        }
        return null;
    }

    public final HighResolutionCalendar getInitializationTime() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getInitializationTime();
        }
        return null;
    }

    @Override
    public ScenarioReader getScenarioReader() {
        return ReaderFactory.create(this.getScenario());
    }

    @Override
    public HighResolutionDuration getDuration() {
        return this.getScenarioReader().getDuration();
    }
}

