/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.reader.BatchActionBlockReader;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.ArrayList;
import java.util.List;

public class BatchReaderImpl
extends EByteBlowerObjectReaderImpl<Batch>
implements BatchReader {
    public BatchReaderImpl(Batch myBatch) {
        super(myBatch);
    }

    @Override
    public List<BatchActionBlockReader> getBatchActionBlockReaders() {
        ArrayList<BatchActionBlockReader> list = new ArrayList<BatchActionBlockReader>();
        for (BatchActionBlock bab : this.getBatchActionBlocks()) {
            list.add(ReaderFactory.create(bab));
        }
        return list;
    }

    @Override
    public List<BatchActionBlock> getBatchActionBlocks() {
        return ((Batch)this.getObject()).getBatchActionBlocks();
    }

    @Override
    public List<BatchActionReader> getBatchActionReaders() {
        ArrayList<BatchActionReader> list = new ArrayList<BatchActionReader>();
        for (BatchActionBlockReader babReader : this.getBatchActionBlockReaders()) {
            list.addAll(babReader.getBatchActionReaders());
        }
        return list;
    }

    @Override
    public BatchActionBlockReader getFirstBatchActionBlockReader() {
        List<BatchActionBlockReader> readers = this.getBatchActionBlockReaders();
        if (readers.isEmpty()) {
            return null;
        }
        return readers.get(0);
    }

    @Override
    public boolean isAbsoluteTimed() {
        return ((Batch)this.getObject()).getStartType() == TimedStartType.ABSOLUTE;
    }

    @Override
    public TimedStartType getStartType() {
        return ((Batch)this.getObject()).getStartType();
    }

    @Override
    public HighResolutionDuration getDuration() {
        HighResolutionDuration totalDuration = new HighResolutionDuration();
        boolean maybeLonger = false;
        for (BatchActionReader reader : this.getBatchActionReaders()) {
            HighResolutionCalendar pause;
            ScenarioReader scenarioReader = reader.getScenarioReader();
            if (scenarioReader == null || scenarioReader.objectIsNull()) continue;
            HighResolutionDuration duration = scenarioReader.getDuration();
            if (duration.isMaybeLonger()) {
                maybeLonger = true;
            }
            if ((pause = reader.getStartTime()) == null || duration == null) continue;
            totalDuration = totalDuration.addRelative(pause);
            totalDuration = totalDuration.addRelative((HighResolutionCalendar)duration);
        }
        if (maybeLonger) {
            totalDuration.setMaybeLonger();
        }
        return totalDuration;
    }
}

