/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import java.util.ArrayList;
import java.util.List;

public class ByteBlowerPortGroupReaderImpl
extends EByteBlowerObjectReaderImpl<ByteBlowerPortGroup>
implements ByteBlowerPortGroupReader {
    public ByteBlowerPortGroupReaderImpl(ByteBlowerPortGroup group) {
        super(group);
    }

    @Override
    public List<ByteBlowerGuiPortReader> getPortReaders() {
        ArrayList<ByteBlowerGuiPortReader> readers = new ArrayList<ByteBlowerGuiPortReader>();
        for (ByteBlowerGuiPort port : ((ByteBlowerPortGroup)this.getObject()).getMembers()) {
            readers.add(ReaderFactory.create(port));
        }
        return readers;
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        ArrayList<SupportedLayer3Configuration> activeLayer3Configurations = new ArrayList<SupportedLayer3Configuration>();
        if (this.hasActiveIpv4Configuration()) {
            activeLayer3Configurations.add(SupportedLayer3Configuration.IPV4);
        }
        if (this.hasActiveIpv6Configuration()) {
            activeLayer3Configurations.add(SupportedLayer3Configuration.IPV6);
        }
        return activeLayer3Configurations;
    }

    @Override
    public boolean hasActiveIpv4Configuration() {
        for (ByteBlowerGuiPort member : ((ByteBlowerPortGroup)this.getObject()).getMembers()) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create(member);
            if (!reader.hasActiveIpv4Configuration()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActiveIpv6Configuration() {
        for (ByteBlowerGuiPort member : ((ByteBlowerPortGroup)this.getObject()).getMembers()) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create(member);
            if (!reader.hasActiveIpv6Configuration()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesLayer3(List<SupportedLayer3Configuration> supportedTypes) {
        for (ByteBlowerGuiPort member : ((ByteBlowerPortGroup)this.getObject()).getMembers()) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create(member);
            if (reader.matchesLayer3(supportedTypes)) continue;
            return false;
        }
        return true;
    }
}

