/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import com.excentis.products.byteblower.model.reader.DhcpReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.Utils;

public class DhcpReaderImpl
extends EByteBlowerObjectReaderImpl<Dhcp>
implements DhcpReader {
    public DhcpReaderImpl(Dhcp myDhcp) {
        super(myDhcp);
    }

    @Override
    public long getDiscoverTimeoutInNanos() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getInitialDiscoverTimeout().getTimeInNanoseconds();
    }

    @Override
    public int getMaximumDiscoverRetries() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getMaximumDiscoverRetries();
    }

    @Override
    public long getRequestTimeoutInNanos() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getInitialRequestTimeout().getTimeInNanoseconds();
    }

    @Override
    public int getMaximumRequestRetries() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getMaximumRequestRetries();
    }

    @Override
    public RetransmissionPolicy getRetransmissionPolicy() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getRetransmissionPolicy();
    }

    @Override
    public String getInitialDiscoverTimeoutString() {
        HighResolutionCalendar value = this.getInitialDiscoverTimeout();
        return Utils.convertToTimeString((HighResolutionCalendar)value);
    }

    @Override
    public String getMaximumDiscoverRetriesString() {
        return Utils.convertToString((int)this.getMaximumDiscoverRetries());
    }

    @Override
    public String getInitialRequestTimeoutString() {
        HighResolutionCalendar value = this.getInitialRequestTimeout();
        return Utils.convertToTimeString((HighResolutionCalendar)value);
    }

    @Override
    public String getMaximumRequestRetriesString() {
        return Utils.convertToString((int)this.getMaximumRequestRetries());
    }

    @Override
    public String getRetransmissionPolicyString() {
        return this.getRetransmissionPolicy().getName();
    }

    @Override
    public HighResolutionCalendar getInitialDiscoverTimeout() {
        return ((Dhcp)this.getObject()).getInitialDiscoverTimeout();
    }

    @Override
    public HighResolutionCalendar getInitialRequestTimeout() {
        return ((Dhcp)this.getObject()).getInitialRequestTimeout();
    }
}

