/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.reader.AddressableDestinationReader;
import com.excentis.products.byteblower.model.reader.AddressableSourceReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.FlowTemplateReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ByteReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFlowReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.TcpFlowReaderImpl;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;

public class FlowReaderImpl
extends EByteBlowerObjectReaderImpl<Flow>
implements FlowReader {
    private static final EditingDomain editingDomain = ByteBlowerEditingDomainProvider.getEditingDomain();

    public FlowReaderImpl(Flow myFlow) {
        super(myFlow);
    }

    private EReference getFlowTemplateEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE;
    }

    private EReference getSourceEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__SOURCE;
    }

    private final EReference getDestinationEReference() {
        return ByteblowerguimodelPackage.Literals.FLOW__DESTINATION;
    }

    private EAttribute getOutOfSequenceDetectionEAttribute() {
        return ByteblowerguimodelPackage.Literals.FLOW__OUT_OF_SEQUENCE_DETECTION;
    }

    @Override
    public String getName() {
        return ((Flow)this.getObject()).getName();
    }

    @Override
    public ByteBlowerGuiPortReader getSourceReader() {
        ByteBlowerGuiPort source = (ByteBlowerGuiPort)((Flow)this.getObject()).getSource();
        return new ByteBlowerGuiPortReaderImpl(source);
    }

    @Override
    public FrameBlastingFlowReader getFrameBlastingFlowReader() {
        if (this.objectIsNull()) {
            return null;
        }
        FlowTemplate flowTemplate = ((Flow)this.getObject()).getFlowTemplate();
        if (flowTemplate instanceof FrameBlastingFlow) {
            return new FrameBlastingFlowReaderImpl((FrameBlastingFlow)flowTemplate);
        }
        return null;
    }

    @Override
    public TcpFlowReader getTcpFlowReader() {
        if (this.objectIsNull()) {
            return null;
        }
        FlowTemplate flowTemplate = ((Flow)this.getObject()).getFlowTemplate();
        if (flowTemplate instanceof TcpFlow) {
            return new TcpFlowReaderImpl((TcpFlow)flowTemplate);
        }
        return null;
    }

    @Override
    public boolean isLatencyEnabled() {
        return !((Flow)this.getObject()).getLatencyAndJitterType().equals((Object)LatencyAndJitterType.NO);
    }

    @Override
    public boolean isRfc2544Flow() {
        FlowTemplate flowTemplate = ((Flow)this.getObject()).getFlowTemplate();
        return flowTemplate instanceof FrameBlastingBenchmark;
    }

    @Override
    public boolean isFrameBlastingFlow() {
        FlowTemplate flowTemplate = ((Flow)this.getObject()).getFlowTemplate();
        return flowTemplate instanceof FrameBlastingFlow;
    }

    @Override
    public boolean isTcpFlow() {
        FlowTemplate flowTemplate = ((Flow)this.getObject()).getFlowTemplate();
        return flowTemplate instanceof TcpFlow;
    }

    @Override
    public boolean doesBasicLatencyMeasurement() {
        Flow flow = (Flow)this.getObject();
        return flow.getLatencyAndJitterType() == LatencyAndJitterType.AVERAGE;
    }

    @Override
    public boolean doesDistributionLatencyMeasurement() {
        Flow flow = (Flow)this.getObject();
        return flow.getLatencyAndJitterType() == LatencyAndJitterType.DISTRIBUTION;
    }

    @Override
    public boolean doesLatencyMeasurement() {
        Flow flow = (Flow)this.getObject();
        return flow.getLatencyAndJitterType() != LatencyAndJitterType.NO;
    }

    @Override
    public boolean doesOosMeasurement() {
        Flow flow = (Flow)this.getObject();
        return flow.getOutOfSequenceDetection() != OutOfSequenceType.NO;
    }

    @Override
    public boolean doesL4S() {
        if (this.isTcpFlow()) {
            return this.getTcpFlowReader().isL4S();
        }
        return false;
    }

    @Override
    public FlowTemplate getFlowTemplate() {
        return ((Flow)this.getObject()).getFlowTemplate();
    }

    @Override
    public AddressableSourceReader<?> getAddressableSourceReader() {
        AddressableSource source = ((Flow)this.getObject()).getSource();
        return ReaderFactory.create(source);
    }

    @Override
    public AddressableDestinationReader<?> getAddressableDestinationReader() {
        AddressableDestination destination = this.getAddressableDestination();
        return ReaderFactory.create(destination);
    }

    @Override
    public AddressableSource getAddressableSource() {
        return ((Flow)this.getObject()).getSource();
    }

    @Override
    public AddressableDestination getAddressableDestination() {
        return ((Flow)this.getObject()).getDestination();
    }

    @Override
    public boolean supportsLatencyMeasurement() {
        return this.getFlowTemplate() instanceof FrameBlastingFlow;
    }

    @Override
    public boolean supportsOosMeasurement() {
        return this.getFlowTemplate() instanceof FrameBlastingFlow;
    }

    @Override
    public String getFlowTemplateName() {
        FlowTemplate template = this.getFlowTemplate();
        return this.checkName((EByteBlowerObject)template);
    }

    @Override
    public String getAddressableSourceName() {
        AddressableSource source = this.getAddressableSource();
        return this.checkName((EByteBlowerObject)source);
    }

    @Override
    public String getAddressableDestinationName() {
        AddressableDestination destination = this.getAddressableDestination();
        if (destination == null) {
            return "click to specify";
        }
        AddressableDestinationReader<?> reader = ReaderFactory.create(destination);
        return reader.getName();
    }

    @Override
    public EList<ByteBlowerGuiPort> getEavesdroppers() {
        return ((Flow)this.getObject()).getByteBlowerGuiPort();
    }

    @Override
    public Byte getTos() {
        return ((Flow)this.getObject()).getTos();
    }

    @Override
    public boolean hasFlowTemplate() {
        return this.getFlowTemplate() != null;
    }

    @Override
    public boolean canEditTos() {
        return this.isTcpFlow();
    }

    public String getTosString(String helpString) {
        if (!this.hasFlowTemplate()) {
            return "-";
        }
        if (this.isTcpFlow()) {
            return "0x" + ByteReader.toHexString(this.getTos());
        }
        if (this.isFrameBlastingFlow()) {
            TreeSet<Byte> tosBytes = new TreeSet<Byte>();
            EList<FrameBlastingFrame> frames = this.getFrameBlastingFlowReader().getFrameBlastingFrames();
            boolean frameDetected = false;
            for (FrameBlastingFrame frame : frames) {
                FrameBlastingFrameReader reader = ReaderFactory.create(frame);
                if (!reader.hasFrame()) continue;
                frameDetected = true;
                FrameReader frameReader = reader.getFrameReader();
                Byte tos = frameReader.getTosByte();
                if (tos == null) continue;
                tosBytes.add(tos);
            }
            if (!frameDetected) {
                return "-";
            }
            if (tosBytes.size() == 0) {
                return "N/A" + helpString;
            }
            if (tosBytes.size() == 1) {
                Byte tosByte = (Byte)tosBytes.first();
                return "0x" + ByteReader.toHexString(tosByte) + helpString;
            }
            return "Mixed" + helpString;
        }
        return "-";
    }

    @Override
    public String getTosString() {
        return this.getTosString("");
    }

    @Override
    public boolean isMulticast() {
        if (this.isFrameBlastingFlow()) {
            return this.getAddressableDestination() instanceof MulticastGroup;
        }
        return false;
    }

    @Override
    public boolean isBroadcast() {
        if (this.isFrameBlastingFlow()) {
            return this.getAddressableDestination() instanceof Broadcast;
        }
        return false;
    }

    @Override
    public boolean isUnicast() {
        if (this.isFrameBlastingFlow()) {
            return this.getAddressableDestination() instanceof Unicast;
        }
        return false;
    }

    @Override
    public boolean hasEavesDroppers() {
        if (this.isFrameBlastingFlow()) {
            return !this.getEavesdroppers().isEmpty();
        }
        return false;
    }

    @Override
    public boolean hasIPv4EavesDroppers() {
        for (ByteBlowerGuiPort eavesDropper : this.getEavesdroppers()) {
            ByteBlowerGuiPortReader eavesReader = ReaderFactory.create(eavesDropper);
            if (!eavesReader.isIPv4()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasIPv6EavesDroppers() {
        for (ByteBlowerGuiPort eavesDropper : this.getEavesdroppers()) {
            ByteBlowerGuiPortReader eavesReader = ReaderFactory.create(eavesDropper);
            if (!eavesReader.isIPv6()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasErrorInFlowTemplate() {
        if (this.getFlowTemplate() == null) {
            return true;
        }
        FlowTemplateReader<?> reader = this.getFlowTemplateReader();
        return reader.hasErrorStatus();
    }

    @Override
    public FlowTemplateReader<?> getFlowTemplateReader() {
        return ReaderFactory.create(this.getFlowTemplate());
    }

    @Override
    public boolean hasErrorInSource() {
        if (this.getAddressableSource() == null) {
            return true;
        }
        AddressableSourceReader<?> reader = this.getAddressableSourceReader();
        if (reader.hasErrorStatus()) {
            return true;
        }
        return !this.sourceMatchesWithFlowTemplate();
    }

    @Override
    public boolean hasErrorInDestination() {
        if (this.getAddressableDestination() == null) {
            return true;
        }
        AddressableDestinationReader<?> reader = this.getAddressableDestinationReader();
        if (reader.hasErrorStatus()) {
            return true;
        }
        if (!this.destinationMatchesWithFlowTemplate()) {
            return true;
        }
        return !this.destinationMatchesWithSource(reader);
    }

    @Override
    public boolean sourceMatchesWithFlowTemplate() {
        if (!this.hasFlowTemplate()) {
            return true;
        }
        AddressableSource source = this.getAddressableSource();
        if (source == null) {
            return false;
        }
        AddressableSourceReader<?> sourceReader = this.getAddressableSourceReader();
        FlowTemplateReader<?> reader = this.getFlowTemplateReader();
        List<SupportedLayer3Configuration> supportedTypes = reader.getSupportedLayer3Types();
        return sourceReader.matchesLayer3(supportedTypes);
    }

    @Override
    public boolean destinationMatchesWithFlowTemplate() {
        if (!this.hasFlowTemplate()) {
            return true;
        }
        AddressableDestination destination = this.getAddressableDestination();
        if (destination == null) {
            return false;
        }
        return this.destinationMatchesWithFlowTemplate(destination);
    }

    @Override
    public boolean hasInvalidOoS() {
        if (!this.isFrameBlastingFlow()) {
            return false;
        }
        return this.getFrameBlastingFlowReader().getRepeatedFrameReaders().size() > 1 && this.doesOosMeasurement();
    }

    @Override
    public boolean eavesdroppersMatchWithFlowTemplate() {
        for (ByteBlowerGuiPort eave : this.getEavesdroppers()) {
            if (this.destinationMatchesWithFlowTemplate((AddressableDestination)eave)) continue;
            return false;
        }
        return true;
    }

    private boolean destinationMatchesWithFlowTemplate(AddressableDestination destination) {
        if (!this.hasFlowTemplate()) {
            return true;
        }
        AddressableDestinationReader<?> destinationReader = ReaderFactory.create(destination);
        FlowTemplateReader<?> reader = this.getFlowTemplateReader();
        List<SupportedLayer3Configuration> supportedTypes = reader.getSupportedLayer3Types();
        return destinationReader.matchesLayer3(supportedTypes);
    }

    @Override
    public boolean hasSource() {
        return this.getAddressableSource() != null;
    }

    @Override
    public boolean destinationMatchesWithSource(AddressableDestinationReader<?> reader) {
        if (!this.hasSource()) {
            return true;
        }
        ByteBlowerGuiPortReader sourceReader = this.getSourceReader();
        List<SupportedLayer3Configuration> supportedTypes = sourceReader.getSupportedLayer3Types();
        return reader.matchesLayer3(supportedTypes);
    }

    @Override
    public boolean hasErrorInEavesDropper(ByteBlowerGuiPort eavesDropper) {
        ByteBlowerGuiPortReader reader = ReaderFactory.create(eavesDropper);
        if (reader.hasError()) {
            return true;
        }
        if (!this.destinationMatchesWithFlowTemplate((AddressableDestination)eavesDropper)) {
            return true;
        }
        return !this.destinationMatchesWithSource(reader);
    }
}

