/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFrameReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FrameReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.MultipleBurstReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ThroughputReader;
import com.excentis.products.byteblower.model.reader.impl.UnitReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class FrameBlastingFlowReaderImpl
extends EByteBlowerObjectReaderImpl<FrameBlastingFlow>
implements FrameBlastingFlowReader {
    private static final String TEXT_UNKNOWN = "?";

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$model$reader$FrameReader$Layer3Type = FrameBlastingFlowReaderImpl.$SWITCH_TABLE$com$excentis$products$byteblower$model$reader$FrameReader$Layer3Type();
    }

    public FrameBlastingFlowReaderImpl(FrameBlastingFlow myFrameBlastingFlow) {
        super(myFrameBlastingFlow);
    }

    private BigDecimal getVirtualNofBytes(ThroughputType throughputType) {
        int totalNofBytes;
        block6: {
            FrameBlastingFlow frameBlastingFlow;
            block4: {
                block5: {
                    totalNofBytes = 0;
                    frameBlastingFlow = (FrameBlastingFlow)this.getObject();
                    FrameModifier frameModifier = frameBlastingFlow.getFrameModifier();
                    if (frameModifier == null) break block4;
                    if (frameModifier instanceof GrowingSizeModifier) {
                        GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameModifier;
                        totalNofBytes = growingSizeModifier.getMinSize() + growingSizeModifier.getMaxSize();
                    } else if (frameModifier instanceof RandomSizeModifier) {
                        RandomSizeModifier randomSizeModifier = (RandomSizeModifier)frameModifier;
                        totalNofBytes = randomSizeModifier.getMinSize() + randomSizeModifier.getMaxSize();
                    }
                    if (throughputType != ThroughputType.FRAME_AND_FCS) break block5;
                    totalNofBytes += 8;
                    break block6;
                }
                if (throughputType != ThroughputType.FRAME_AND_ALL_OTHER_FIELDS) break block6;
                totalNofBytes += 48;
                break block6;
            }
            for (FrameBlastingFrame frameBlastingFrame : frameBlastingFlow.getFrameBlastingFrames()) {
                int weight = frameBlastingFrame.getWeight();
                Frame frame = frameBlastingFrame.getFrame();
                if (frame == null) continue;
                FrameReaderImpl frameReader = new FrameReaderImpl(frame);
                int byteSize = frameReader.getByteSize(throughputType);
                totalNofBytes += weight * byteSize;
            }
        }
        return new BigDecimal(totalNofBytes);
    }

    private BigDecimal getVirtualNofBits(ThroughputType throughputType) {
        BigDecimal bytes = this.getVirtualNofBytes(throughputType);
        BigDecimal bits = ThroughputReader.convertBytesToBits(bytes);
        return bits;
    }

    private BigDecimal getVirtualNofFrames() {
        int totalNofFrames = 0;
        totalNofFrames = this.usingFrameModifier() ? 2 : this.getTotalWeight();
        return new BigDecimal(totalNofFrames);
    }

    private int getTotalWeight() {
        int totalWeight = 0;
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        for (FrameBlastingFrame frameBlastingFrame : frameBlastingFlow.getFrameBlastingFrames()) {
            if (frameBlastingFrame.getFrame() == null) continue;
            totalWeight += frameBlastingFrame.getWeight();
        }
        return totalWeight;
    }

    @Override
    public List<FrameReader> getRepeatedFrameReaders() {
        ArrayList<FrameReader> frameReaders = new ArrayList<FrameReader>();
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        for (FrameBlastingFrame frameBlastingFrame : frameBlastingFlow.getFrameBlastingFrames()) {
            Frame frame = frameBlastingFrame.getFrame();
            if (frame == null) continue;
            int weight = frameBlastingFrame.getWeight();
            int i = 0;
            while (i < weight) {
                frameReaders.add(new FrameReaderImpl(frame));
                ++i;
            }
        }
        return frameReaders;
    }

    @Override
    public UniqueEList<FrameReader> getUniqueFrames() {
        UniqueEList frameReaders = new UniqueEList();
        UniqueEList frameCheckList = new UniqueEList();
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        for (FrameBlastingFrame frameBlastingFrame : frameBlastingFlow.getFrameBlastingFrames()) {
            Frame frame = frameBlastingFrame.getFrame();
            if (frameCheckList.contains((Object)frame)) continue;
            frameCheckList.add((Object)frame);
            frameReaders.add((Object)new FrameReaderImpl(frame));
        }
        return frameReaders;
    }

    private boolean usingFrameModifier() {
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        return frameBlastingFlow.getFrameModifier() != null;
    }

    private ThroughputType getProjectThroughputType() {
        return this.getProject().getThroughputType();
    }

    private DataRateUnit getProjectDataRateUnit() {
        return this.getProject().getThroughputUnit();
    }

    @Override
    public BigDecimal getThroughput() {
        DataRateUnit dataRateUnit = this.getProjectDataRateUnit();
        return this.getThroughput(dataRateUnit);
    }

    @Override
    public BigDecimal getThroughput(DataRateUnit dataRateUnit) {
        ThroughputType throughputType = this.getProjectThroughputType();
        return this.getThroughput(throughputType, dataRateUnit);
    }

    @Override
    public BigDecimal getThroughput(ThroughputType throughputType) {
        return this.getThroughput(throughputType, DataRateUnit.BPS);
    }

    @Override
    public BigDecimal getThroughput(ThroughputType throughputType, DataRateUnit unit) {
        BigDecimal virtualNofBits = this.getVirtualNofBits(throughputType);
        if (virtualNofBits.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal virtualNofFrames = this.getVirtualNofFrames();
        BigDecimal frameIntervalInNs = new BigDecimal(this.getFrameIntervalInNanoseconds());
        BigDecimal totalIntervalNs = virtualNofFrames.multiply(frameIntervalInNs);
        BigDecimal nanosInSec = new BigDecimal(HighResolutionCalendar.NANOSECONDS_IN_SECOND);
        virtualNofBits = virtualNofBits.multiply(nanosInSec);
        BigDecimal throughput = virtualNofBits.divide(totalIntervalNs, MathContext.DECIMAL128);
        if (this.isBursty()) {
            throughput = this.makeBursty(throughput);
        }
        return ThroughputReader.convertTo(throughput, unit);
    }

    private BigDecimal makeBursty(BigDecimal throughput) {
        TimingModifier timingModifier = this.getTimingModifier();
        MultipleBurst multipleBurst = (MultipleBurst)timingModifier;
        MultipleBurstReaderImpl multipleBurstReader = new MultipleBurstReaderImpl(multipleBurst);
        BigDecimal nofFramesPerBurst = multipleBurstReader.getNofFramesPerBurstBigDecimal();
        BigDecimal burstDuration = this.getBurstDuration(nofFramesPerBurst);
        BigDecimal interBurstGap = multipleBurstReader.getInterBurstGapBigDecimal();
        BigDecimal burstInterval = burstDuration.add(interBurstGap);
        throughput = throughput.multiply(burstDuration);
        throughput = throughput.divide(burstInterval, MathContext.DECIMAL128);
        return throughput;
    }

    private BigDecimal getBurstDuration(BigDecimal nofFrames) {
        BigDecimal frameInterval = new BigDecimal(this.getFrameIntervalInNanoseconds());
        BigDecimal burstDuration = frameInterval.multiply(nofFrames);
        return burstDuration;
    }

    private boolean isBursty() {
        return this.getTimingModifier() != null;
    }

    @Override
    public HighResolutionCalendar getFrameInterval() {
        return this.getFrameBlastingFlow().getFrameInterval();
    }

    @Override
    public long getFrameIntervalInNanoseconds() {
        return this.getFrameInterval().getTimeInNanoseconds();
    }

    private FrameBlastingFlow getFrameBlastingFlow() {
        return (FrameBlastingFlow)this.getObject();
    }

    @Override
    public String getThroughputString(DataRateUnit dataRateUnit) {
        ThroughputType throughputType = this.getProjectThroughputType();
        return this.getThroughputString(throughputType, dataRateUnit);
    }

    @Override
    public String getThroughputString(ThroughputType throughputType) {
        DataRateUnit dataRateUnit = this.getDataRateUnit();
        return this.getThroughputString(throughputType, dataRateUnit);
    }

    @Override
    public DataRateUnit getDataRateUnit() {
        FrameBlastingFlow frameBlastingFlow = this.getFrameBlastingFlow();
        return frameBlastingFlow.getDataRateUnit();
    }

    @Override
    public String getThroughputString(ThroughputType throughputType, DataRateUnit dataRateUnit) {
        BigDecimal throughput = this.getThroughput(throughputType, dataRateUnit);
        String throughputString = ThroughputReader.getThroughputString(throughput, dataRateUnit);
        return throughputString != null ? throughputString : TEXT_UNKNOWN;
    }

    @Override
    public BigInteger getFrameInterval_ToGetThroughput(BigDecimal bps, ThroughputType throughputType) {
        if (bps.equals(BigDecimal.ZERO)) {
            return BigInteger.ZERO;
        }
        BigDecimal avgBitsPerFrame = this.getAvgBitsPerFrame(bps, throughputType);
        BigDecimal frameInterval = avgBitsPerFrame.divide(bps, MathContext.DECIMAL128);
        frameInterval = UnitReader.convertTo(frameInterval, UnitReader.UnitPrefix.NANO);
        return frameInterval.toBigInteger();
    }

    @Override
    public BigInteger getFrameInterval_ToGetFrameRate(BigDecimal rate) {
        BigDecimal nsInterval = UnitReader.trillion.divide(rate, 0, 6);
        return nsInterval.toBigInteger();
    }

    private BigDecimal getAvgBitsPerFrame(BigDecimal bps, ThroughputType throughputType) {
        BigDecimal totalBitWeight = this.getVirtualNofBits(throughputType);
        if (totalBitWeight.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalFrameWeight = this.getVirtualNofFrames();
        return totalBitWeight.divide(totalFrameWeight, MathContext.DECIMAL128);
    }

    @Override
    public EList<FrameBlastingFrame> getFrameBlastingFrames() {
        return this.getFrameBlastingFlow().getFrameBlastingFrames();
    }

    @Override
    public BigDecimal getFrameRate() {
        BigDecimal nsInterval = new BigDecimal(this.getFrameIntervalInNanoseconds());
        if (nsInterval.compareTo(BigDecimal.ZERO) == 0) {
            System.err.println("FrameBlastingFlowReader::getFrameRate : Frame Interval is ZERO");
            return null;
        }
        MathContext mathContext = MathContext.DECIMAL128;
        BigDecimal frameRate = UnitReader.trillion.divide(nsInterval, mathContext);
        return frameRate;
    }

    @Override
    public String getFrameInterval_HumanReadable() {
        HighResolutionCalendar frameInterval = this.getFrameInterval();
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)frameInterval);
    }

    @Override
    public FrameModifier getFrameModifier() {
        return this.getFrameBlastingFlow().getFrameModifier();
    }

    @Override
    public TimingModifier getTimingModifier() {
        return this.getFrameBlastingFlow().getTimingModifier();
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        FrameReader firstFrameReader;
        FrameReader.Layer3Type type = FrameReader.Layer3Type.UNKNOWN;
        UniqueEList<FrameReader> frameReaders = this.getUniqueFrames();
        if (!frameReaders.isEmpty() && (firstFrameReader = (FrameReader)frameReaders.get(0)) != null) {
            type = firstFrameReader.getLayer3Type();
        }
        ArrayList<SupportedLayer3Configuration> supported = new ArrayList<SupportedLayer3Configuration>();
        switch (type) {
            case ARP: {
                supported.add(SupportedLayer3Configuration.IPV4);
                supported.add(SupportedLayer3Configuration.IPV6);
                break;
            }
            case IPV4: {
                supported.add(SupportedLayer3Configuration.IPV4);
                break;
            }
            case IPV6: {
                supported.add(SupportedLayer3Configuration.IPV6);
                break;
            }
            case UNKNOWN: {
                supported.add(SupportedLayer3Configuration.IPV4);
                supported.add(SupportedLayer3Configuration.IPV6);
                break;
            }
        }
        return supported;
    }

    @Override
    public String getName() {
        return ((FrameBlastingFlow)this.getObject()).getName();
    }

    @Override
    public List<FrameBlastingFrameReader> getFrameBlastingFrameReaders() {
        ArrayList<FrameBlastingFrameReader> readers = new ArrayList<FrameBlastingFrameReader>();
        for (FrameBlastingFrame frame : this.getFrameBlastingFrames()) {
            readers.add(new FrameBlastingFrameReaderImpl(frame));
        }
        return readers;
    }

    @Override
    public boolean dataRateTooBig() {
        return false;
    }
}

