/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.frame.ARPPacket;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.TCPPacket;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameFieldModifier;
import com.excentis.products.byteblower.model.FrameL3Type;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import org.eclipse.emf.common.util.EList;

public class FrameReaderImpl
extends EByteBlowerObjectReaderImpl<Frame>
implements FrameReader {
    private static final int BUFFER_SIZE = 11000;
    private byte[] buffer = new byte[11000];
    private EthernetPacket ethernet;
    private Ipv4Packet ipv4;
    private Ipv6Packet ipv6;
    private ARPPacket arp;
    private ProtocolLayer currentLayer3;
    private TCPPacket ipv4_tcp;
    private UDPPacket ipv4_udp;
    private TCPPacket ipv6_tcp;
    private UDPPacket ipv6_udp;
    private ProtocolLayer currentLayer4;

    public FrameReaderImpl(Frame frame) {
        super(frame);
        if (!this.objectIsNull()) {
            this.createLayers();
            this.update();
        }
    }

    private void createLayers() {
        this.ethernet = new EthernetPacket();
        this.ipv4 = new Ipv4Packet((ProtocolLayer)this.ethernet);
        this.ipv6 = new Ipv6Packet((ProtocolLayer)this.ethernet);
        this.arp = new ARPPacket((ProtocolLayer)this.ethernet);
        this.ipv4_tcp = new TCPPacket((ProtocolLayer)this.ipv4);
        this.ipv4_udp = new UDPPacket((ProtocolLayer)this.ipv4);
        this.ipv6_tcp = new TCPPacket((ProtocolLayer)this.ipv6);
        this.ipv6_udp = new UDPPacket((ProtocolLayer)this.ipv6);
    }

    @Override
    public boolean isContained() {
        Frame myFrame = (Frame)this.getObject();
        return myFrame != null && myFrame.eContainer() != null;
    }

    @Override
    public FrameReader.Layer3Type getLayer3Type() {
        if (this.currentLayer3 == this.arp) {
            return FrameReader.Layer3Type.ARP;
        }
        if (this.currentLayer3 == this.ipv4) {
            return FrameReader.Layer3Type.IPV4;
        }
        if (this.currentLayer3 == this.ipv6) {
            return FrameReader.Layer3Type.IPV6;
        }
        return FrameReader.Layer3Type.UNKNOWN;
    }

    @Override
    public FrameReader.Layer4Type getLayer4Type() {
        if (this.currentLayer4 == this.ipv4_tcp || this.currentLayer4 == this.ipv6_tcp) {
            return FrameReader.Layer4Type.TCP;
        }
        if (this.currentLayer4 == this.ipv4_udp || this.currentLayer4 == this.ipv6_udp) {
            return FrameReader.Layer4Type.UDP;
        }
        return FrameReader.Layer4Type.UNKNOWN;
    }

    private void update() {
        this.update(this.getFrame().getBytesHexString());
    }

    private static String extendToSize(String baseString, int minimumSize) {
        StringBuilder builder = new StringBuilder(baseString);
        while (builder.length() < minimumSize) {
            builder.append('0');
        }
        return builder.toString();
    }

    private void update(String hexBytes) {
        int mininumSize = 120;
        hexBytes = FrameReaderImpl.extendToSize(hexBytes, 120);
        this.resetEthernet(hexBytes);
        this.updateLayers();
    }

    private void updateLayers() {
        this.updateLayer3();
        this.updateLayer4();
    }

    private void updateLayer3() {
        ProtocolField ethernetPayload = this.ethernet.getPayload();
        switch (this.ethernet.getType()) {
            case 2048: {
                this.currentLayer3 = this.ipv4;
                break;
            }
            case 34525: {
                this.currentLayer3 = this.ipv6;
                break;
            }
            case 2054: {
                this.currentLayer3 = this.arp;
                break;
            }
            default: {
                return;
            }
        }
        int size = ethernetPayload.dump(this.buffer, 0);
        this.currentLayer3.set(size, this.buffer, 0);
        this.ethernet.setPayload((ProtocolField)this.currentLayer3);
    }

    private void updateLayer4() {
        if (this.currentLayer3 == this.ipv4) {
            ProtocolField ipv4Payload = this.ipv4.getPayload();
            switch (this.ipv4.getProtocol()) {
                case 6: {
                    this.currentLayer4 = this.ipv4_tcp;
                    break;
                }
                case 17: {
                    this.currentLayer4 = this.ipv4_udp;
                    break;
                }
                default: {
                    return;
                }
            }
            int size = ipv4Payload.dump(this.buffer, 0);
            this.currentLayer4.set(size, this.buffer, 0);
            this.ipv4.setPayload((ProtocolField)this.currentLayer4);
        } else if (this.currentLayer3 == this.ipv6) {
            ProtocolField ipv6Payload = this.ipv6.getPayload();
            switch (this.ipv6.getNextHeader()) {
                case 6: {
                    this.currentLayer4 = this.ipv6_tcp;
                    break;
                }
                case 17: {
                    this.currentLayer4 = this.ipv6_udp;
                    break;
                }
                default: {
                    return;
                }
            }
            int size = ipv6Payload.dump(this.buffer, 0);
            this.currentLayer4.set(size, this.buffer, 0);
            this.ipv6.setPayload((ProtocolField)this.currentLayer4);
        } else {
            return;
        }
    }

    private void resetEthernet(String hexBytes) {
        int frameByteSize = hexBytes.length() / 2;
        byte[] bytes = this.getBytes(hexBytes);
        this.ethernet.set(frameByteSize * 8, bytes, 0);
    }

    @Override
    public byte[] getBytes() {
        return this.getBytes(this.getFrame().getBytesHexString());
    }

    private byte[] getBytes(String bytesHexString) {
        int size = 0;
        if (bytesHexString != null) {
            size = bytesHexString.length() / 2;
        }
        byte[] bts = new byte[size];
        try {
            int i = 0;
            while (i < size) {
                String byteString = bytesHexString.substring(2 * i, 2 * i + 2);
                bts[i] = (byte)Integer.parseInt(byteString, 16);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("FRAME GETBYTES ERROR : " + e.getMessage());
        }
        return bts;
    }

    @Override
    public ARPPacket getArp() {
        return this.arp;
    }

    @Override
    public EthernetPacket getEthernet() {
        return this.ethernet;
    }

    @Override
    public Ipv4Packet getIpv4() {
        return this.ipv4;
    }

    @Override
    public Ipv6Packet getIpv6() {
        return this.ipv6;
    }

    @Override
    public UDPPacket getCurrentUdp() {
        if (this.currentLayer4 instanceof UDPPacket) {
            return (UDPPacket)this.currentLayer4;
        }
        return null;
    }

    @Override
    public TCPPacket getCurrentTcp() {
        if (this.currentLayer4 instanceof TCPPacket) {
            return (TCPPacket)this.currentLayer4;
        }
        return null;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String getHexBytes() {
        return this.getFrame().getBytesHexString();
    }

    @Override
    public Frame getFrame() {
        return (Frame)this.getObject();
    }

    @Override
    public int getByteSize(ThroughputType throughputType) {
        String myBytesHexString = this.getFrame().getBytesHexString();
        int byteSize = myBytesHexString.length() / 2;
        switch (throughputType.getValue()) {
            case 1: {
                byteSize += 4;
                break;
            }
            case 2: {
                byteSize += 24;
                break;
            }
        }
        return byteSize;
    }

    @Override
    public int getBitSize(ThroughputType throughputType) {
        int byteSize = this.getByteSize(throughputType);
        return byteSize * 8;
    }

    @Override
    public int getL4Type() {
        int type = this.ethernet.getType();
        switch (type) {
            case 2048: {
                return this.ipv4.getProtocol();
            }
            case 34525: {
                return this.ipv6.getNextHeader();
            }
        }
        return -1;
    }

    @Override
    public FrameL3Type getEthernetType() {
        String hexBytes = this.getHexBytes();
        int frameByteSize = hexBytes.length() / 2;
        byte[] bytes = this.getBytes(hexBytes);
        EthernetPacket ethernet = new EthernetPacket(frameByteSize * 8, bytes);
        int ethernetType = ethernet.getType();
        switch (ethernetType) {
            case 2048: {
                return FrameL3Type.IPV4_LITERAL;
            }
            case 34525: {
                return FrameL3Type.IPV6_LITERAL;
            }
            case 2054: {
                return FrameL3Type.ARP_LITERAL;
            }
        }
        return FrameL3Type.NONE_LITERAL;
    }

    @Override
    public String getName() {
        return ((Frame)this.getObject()).getName();
    }

    @Override
    public boolean hasFrameModifiers() {
        return !this.getModifiers().isEmpty();
    }

    @Override
    public EList<FrameModifier> getModifiers() {
        return ((Frame)this.getObject()).getModifiers();
    }

    @Override
    public FrameFieldModifier getFrameFieldModifier() {
        if (this.hasFrameModifiers()) {
            return (FrameFieldModifier)this.getModifiers().get(0);
        }
        return null;
    }

    @Override
    public Byte getTosByte() {
        if (this.getLayer3Type() == FrameReader.Layer3Type.IPV4) {
            return (byte)this.getIpv4().getTOS();
        }
        if (this.getLayer3Type() == FrameReader.Layer3Type.IPV6) {
            return (byte)this.getIpv6().getTrafficClass();
        }
        return null;
    }
}

