/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.impl.ByteCollectionReader;
import com.excentis.products.byteblower.model.reader.impl.NetworkAddressReaderImpl;
import java.util.List;
import java.util.regex.Pattern;

public class MacAddressReaderImpl
extends NetworkAddressReaderImpl<MacAddress>
implements MacAddressReader {
    private static final String MacAddressPart = "([0-9a-fA-F]{2,2})";
    public static final String AllowedMacAddressSeparators = ":.-";
    public static final Character UnifiedMacAddressSeparator = Character.valueOf('-');
    private static final String AllowedMacAddressSeparatorsRegex = "[:.-]";
    private static final String CompleteMacAddress = "^([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})[:.-]([0-9a-fA-F]{2,2})$";
    private static final String MacAddressShortPart = "([0-9a-fA-F]{1,2})";
    private static final String ShortCompleteMacAddress = "^([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})[:.-]([0-9a-fA-F]{1,2})$";

    public MacAddressReaderImpl(MacAddress mac) {
        super(mac);
    }

    @Override
    protected final String getNetworkAddressTypeName() {
        return "MAC Address";
    }

    @Override
    protected final int getNetworkAddressSize() {
        return 6;
    }

    @Override
    public String getAddress() {
        ByteCollectionReader byteCollectionController = new ByteCollectionReader((List<Byte>)((MacAddress)this.getObject()).getBytes());
        return byteCollectionController.toByteString(Character.valueOf('-'));
    }

    public static boolean isValid(String string) {
        return Pattern.matches(ShortCompleteMacAddress, string);
    }

    public static boolean isComplete(String macAddress) {
        return Pattern.matches(CompleteMacAddress, macAddress);
    }

    @Override
    public MacAddress getIncrementedAddress() {
        MacAddress newAddress = ByteblowerguimodelFactory.eINSTANCE.createMacAddress();
        newAddress.getBytes().addAll(this.getIncrementedBytes());
        return newAddress;
    }

    @Override
    public boolean isValid() {
        return this.isValid(false);
    }

    @Override
    public boolean isValid(boolean allowZero) {
        boolean validAddress = MacAddressReaderImpl.isValid(this.getAddress());
        if (!allowZero && this.isZero()) {
            return false;
        }
        return validAddress;
    }

    @Override
    public boolean isGroupAddress() {
        Byte mostSignificantByte = (Byte)((MacAddress)this.getObject()).getBytes().get(0);
        int leastSignificantBit = mostSignificantByte & 1;
        return leastSignificantBit == 1;
    }
}

