/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.AddressableDestinationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class MulticastGroupReaderImpl
extends AddressableDestinationReaderImpl<MulticastGroup>
implements MulticastGroupReader {
    public MulticastGroupReaderImpl(MulticastGroup multicastGroup) {
        super(multicastGroup);
        if (multicastGroup.getMulticastIpAddress() == null) {
            System.out.println("ALARM");
        }
    }

    @Override
    public String getMulticastMacAddressString() {
        IpAddress multicastIpAddress = ((MulticastGroup)this.getObject()).getMulticastIpAddress();
        IpAddressReader<? extends IpAddress> reader = ReaderFactory.create(multicastIpAddress);
        return reader.getMulticastMacAddressString();
    }

    private IpAddress getMulticastIpAddress() {
        MulticastGroup group = (MulticastGroup)this.getObject();
        return group.getMulticastIpAddress();
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        ArrayList<SupportedLayer3Configuration> supported = new ArrayList<SupportedLayer3Configuration>();
        IpAddress myMulticastIpAddress = this.getMulticastIpAddress();
        if (myMulticastIpAddress instanceof Ipv4Address) {
            supported.add(SupportedLayer3Configuration.IPV4);
        } else if (myMulticastIpAddress instanceof Ipv6Address) {
            supported.add(SupportedLayer3Configuration.IPV6);
        }
        return supported;
    }

    @Override
    public IpAddress getIpAddress() {
        return ((MulticastGroup)this.getObject()).getMulticastIpAddress();
    }

    @Override
    public String getMulticastIpAddressString() {
        return IpAddressReaderImpl.getAddress(((MulticastGroup)this.getObject()).getMulticastIpAddress());
    }

    @Override
    public boolean isIpv4() {
        return ((MulticastGroup)this.getObject()).getMulticastIpAddress() instanceof Ipv4Address;
    }

    @Override
    public boolean isIpv6() {
        return ((MulticastGroup)this.getObject()).getMulticastIpAddress() instanceof Ipv6Address;
    }

    @Override
    public EList<MulticastMemberPort> getMulticastMemberPorts() {
        return ((MulticastGroup)this.getObject()).getMulticastMemberPort();
    }

    @Override
    public IpAddressReader<?> getMulticastIpAddressReader() {
        return ReaderFactory.create(this.getIpAddress());
    }

    @Override
    public boolean usesByteBlowerGuiPort(ByteBlowerGuiPort byteBlowerGuiPort) {
        for (MulticastMemberPort member : this.getMulticastMemberPorts()) {
            if (member.getByteBlowerGuiPort() != byteBlowerGuiPort) continue;
            return true;
        }
        return false;
    }
}

