/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.MulticastSourceByteBlowerGuiPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.MulticastSourceGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class MulticastSourceGroupReaderImpl
extends EByteBlowerObjectReaderImpl<MulticastSourceGroup>
implements MulticastSourceGroupReader {
    public MulticastSourceGroupReaderImpl(MulticastSourceGroup multicastSourceGroup) {
        super(multicastSourceGroup);
    }

    @Override
    public List<ByteBlowerGuiPort> getPorts() {
        ArrayList<ByteBlowerGuiPort> ports = new ArrayList<ByteBlowerGuiPort>();
        for (MulticastSourceByteBlowerGuiPort sourceGroupPort : ((MulticastSourceGroup)this.getObject()).getMulticastSourceByteBlowerGuiPort()) {
            ports.add(sourceGroupPort.getByteBlowerGuiPort());
        }
        return ports;
    }

    @Override
    public List<String> getIpAddressStrings() {
        ArrayList<String> ipAddressStrings = new ArrayList<String>();
        for (IpAddress ipAddress : ((MulticastSourceGroup)this.getObject()).getIpAddresses()) {
            if (ipAddress instanceof Ipv4Address) {
                ipAddressStrings.add(IpAddressReaderImpl.getAddress(ipAddress));
                continue;
            }
            if (!(ipAddress instanceof Ipv6Address)) continue;
            ipAddressStrings.add(IpAddressReaderImpl.getAddress(ipAddress));
        }
        return ipAddressStrings;
    }

    @Override
    public EList<MulticastSourceByteBlowerGuiPort> getMulticastSourceByteBlowerGuiPorts() {
        return ((MulticastSourceGroup)this.getObject()).getMulticastSourceByteBlowerGuiPort();
    }

    @Override
    public EList<IpAddress> getIpAddresses() {
        return ((MulticastSourceGroup)this.getObject()).getIpAddresses();
    }

    @Override
    public boolean containsIpv4() {
        for (IpAddress msIpAddress : this.getIpAddresses()) {
            if (!(msIpAddress instanceof Ipv4Address)) continue;
            return true;
        }
        for (MulticastSourceByteBlowerGuiPort port : this.getMulticastSourceByteBlowerGuiPorts()) {
            ByteBlowerGuiPortReader reader;
            ByteBlowerGuiPort bbPort = port.getByteBlowerGuiPort();
            if (bbPort == null || !(reader = ReaderFactory.create(bbPort)).isIPv4()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsIpv6() {
        for (IpAddress msIpAddress : this.getIpAddresses()) {
            if (!(msIpAddress instanceof Ipv6Address)) continue;
            return true;
        }
        for (MulticastSourceByteBlowerGuiPort port : this.getMulticastSourceByteBlowerGuiPorts()) {
            ByteBlowerGuiPortReader reader;
            ByteBlowerGuiPort bbPort = port.getByteBlowerGuiPort();
            if (bbPort == null || !(reader = ReaderFactory.create(bbPort)).isIPv6()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesByteBlowerGuiPort(ByteBlowerGuiPort byteBlowerGuiPort) {
        for (MulticastSourceByteBlowerGuiPort member : this.getMulticastSourceByteBlowerGuiPorts()) {
            if (member.getByteBlowerGuiPort() != byteBlowerGuiPort) continue;
            return true;
        }
        return false;
    }
}

