/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerServerType;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Measurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class ScenarioReaderImpl
extends EByteBlowerObjectReaderImpl<Scenario>
implements ScenarioReader {
    private static Comparator<FlowMeasurement> comparator = null;

    public ScenarioReaderImpl(Scenario myScenario) {
        super(myScenario);
    }

    @Override
    public EList<ByteBlowerGuiPort> getInvolvedPorts() {
        UniqueEList involvedPorts = new UniqueEList();
        for (FlowMeasurement flowMeasurement : this.getFlowMeasurements()) {
            FlowMeasurementReader flowMeasurementReader = ReaderFactory.create(flowMeasurement);
            involvedPorts.addAll(flowMeasurementReader.getInvolvedPorts());
        }
        return involvedPorts;
    }

    @Override
    public EList<ScenarioReader.ServerDescription> getInvolvedServers() {
        UniqueEList involvedServers = new UniqueEList();
        EList<ByteBlowerGuiPort> involvedPorts = this.getInvolvedPorts();
        for (ByteBlowerGuiPort port : involvedPorts) {
            ByteBlowerGuiPortReader portReader = ReaderFactory.create(port);
            ByteBlowerGuiPortConfiguration portConfig = portReader.getByteBlowerGuiPortConfiguration();
            String serverAddress = portConfig.getPhysicalServerAddress();
            ServerDescriptionImpl description = new ServerDescriptionImpl(serverAddress, portConfig.getPhysicalServerType());
            involvedServers.add((Object)description);
        }
        return involvedServers;
    }

    @Override
    public EList<FlowMeasurement> getFlowMeasurements() {
        UniqueEList flowMeasurements = new UniqueEList();
        for (Measurement measurement : ((Scenario)this.getObject()).getMeasurements()) {
            if (!(measurement instanceof FlowMeasurement)) continue;
            flowMeasurements.add((Object)((FlowMeasurement)measurement));
        }
        return flowMeasurements;
    }

    @Override
    public HighResolutionDuration getDuration() {
        if (this.objectIsNull()) {
            return new HighResolutionDuration();
        }
        HighResolutionDuration biggestStopTime = new HighResolutionDuration();
        for (FlowMeasurement measurement : this.getFlowMeasurements()) {
            FlowMeasurementReader reader = ReaderFactory.create(measurement);
            HighResolutionDuration stopTime = reader.getStopTime();
            if (stopTime.isMaybeLonger()) {
                biggestStopTime.setMaybeLonger();
            }
            if (biggestStopTime.compareTo((Calendar)stopTime) != -1) continue;
            biggestStopTime.setTimeInNanoseconds(stopTime.getTimeInNanoseconds());
        }
        return biggestStopTime;
    }

    @Override
    public EList<Measurement> getMeasurements() {
        return ((Scenario)this.getObject()).getMeasurements();
    }

    @Override
    public List<FlowMeasurement> getSortedFlowMeasurements() {
        EList<FlowMeasurement> flowMeasurements = this.getFlowMeasurements();
        ArrayList<FlowMeasurement> sortedFlowMeasurements = new ArrayList<FlowMeasurement>();
        sortedFlowMeasurements.addAll((Collection<FlowMeasurement>)flowMeasurements);
        Collections.sort(sortedFlowMeasurements, ScenarioReaderImpl.getSorter());
        return sortedFlowMeasurements;
    }

    private static Comparator<FlowMeasurement> getSorter() {
        if (comparator == null) {
            comparator = new Comparator<FlowMeasurement>(){

                @Override
                public int compare(FlowMeasurement lhs, FlowMeasurement rhs) {
                    HighResolutionCalendar rhsTime;
                    FlowMeasurementReaderImpl lhsReader = new FlowMeasurementReaderImpl(lhs);
                    FlowMeasurementReaderImpl rhsReader = new FlowMeasurementReaderImpl(rhs);
                    HighResolutionCalendar lhsTime = lhsReader.getStartTime();
                    int compared = lhsTime.compareTo((Calendar)(rhsTime = rhsReader.getStartTime()));
                    if (compared == 0) {
                        Integer lhPos = lhsReader.getIndexInContainer();
                        Integer rhPos = rhsReader.getIndexInContainer();
                        compared = lhPos.compareTo(rhPos);
                    }
                    return compared;
                }
            };
        }
        return comparator;
    }

    @Override
    public boolean blockResultsOverTime() {
        return this.getFlowMeasurements().size() > 100;
    }

    @Override
    public boolean allowResultsOverTime() {
        return this.getProjectReader().isResultsOverTimeEnabled() && !this.blockResultsOverTime();
    }

    @Override
    public boolean preventResultsOverTime() {
        return this.getProjectReader().isResultsOverTimeEnabled() && this.blockResultsOverTime();
    }

    private static class ServerDescriptionImpl
    implements ScenarioReader.ServerDescription {
        private final String networkAddress;
        private final ByteBlowerServerType type;

        public ServerDescriptionImpl(String networkAddress, ByteBlowerServerType type) {
            this.networkAddress = networkAddress;
            this.type = type;
        }

        @Override
        public String getNetworkAddress() {
            return this.networkAddress;
        }

        @Override
        public ByteBlowerServerType getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode() + this.networkAddress.hashCode();
        }

        public boolean equals(Object oth) {
            if (this.networkAddress == null) {
                return false;
            }
            if (oth instanceof ScenarioReader.ServerDescription) {
                ScenarioReader.ServerDescription othServer = (ScenarioReader.ServerDescription)oth;
                return this.networkAddress.equals(othServer.getNetworkAddress()) && this.type.equals((Object)othServer.getType());
            }
            return false;
        }
    }
}

