/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.reader.impl.PayloadReader;
import java.math.BigDecimal;

public class ThroughputReader
extends PayloadReader {
    public static BigDecimal convertThroughput(BigDecimal throughput, DataRateUnit fromUnit, DataRateUnit toUnit) {
        PayloadUnit fromPayloadUnit = ThroughputReader.getPayloadUnit(fromUnit);
        PayloadUnit toPayloadUnit = ThroughputReader.getPayloadUnit(toUnit);
        return ThroughputReader.convertPayload(throughput, fromPayloadUnit, toPayloadUnit);
    }

    private static PayloadUnit getPayloadUnit(DataRateUnit unit) {
        switch (unit) {
            case BPS: {
                return PayloadUnit.BITS;
            }
            case BYTESPS: {
                return PayloadUnit.BYTES;
            }
            case GBPS: {
                return PayloadUnit.GBITS;
            }
            case GBYTESPS: {
                return PayloadUnit.GBYTES;
            }
            case KBPS: {
                return PayloadUnit.KBITS;
            }
            case KBYTESPS: {
                return PayloadUnit.KBYTES;
            }
            case MBPS: {
                return PayloadUnit.MBITS;
            }
            case MBYTESPS: {
                return PayloadUnit.MBYTES;
            }
        }
        System.err.println("ThroughputReader::getPayloadUnit : unsupported unit : " + unit);
        return null;
    }

    static BigDecimal convertTo(BigDecimal value, DataRateUnit toUnit) {
        PayloadUnit toPayloadUnit = ThroughputReader.getPayloadUnit(toUnit);
        return ThroughputReader.convertTo(value, toPayloadUnit);
    }

    static String getThroughputString(BigDecimal throughput, DataRateUnit dataRateUnit) {
        PayloadUnit payloadUnit = ThroughputReader.getPayloadUnit(dataRateUnit);
        return ThroughputReader.getThroughputString(throughput, payloadUnit);
    }
}

