/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.UnicastReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.AddressableDestinationReaderImpl;
import java.util.ArrayList;
import java.util.List;

public class UnicastReaderImpl
extends AddressableDestinationReaderImpl<Unicast>
implements UnicastReader {
    public UnicastReaderImpl(Unicast unicast) {
        super(unicast);
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        ArrayList<SupportedLayer3Configuration> supported = new ArrayList<SupportedLayer3Configuration>();
        IpAddress myIpAddress = ((Unicast)this.getObject()).getIpAddress();
        if (myIpAddress instanceof Ipv4Address) {
            supported.add(SupportedLayer3Configuration.IPV4);
        } else if (myIpAddress instanceof Ipv6Address) {
            supported.add(SupportedLayer3Configuration.IPV6);
        }
        return supported;
    }

    @Override
    public String getAddress() {
        IpAddress address = ((Unicast)this.getObject()).getIpAddress();
        IpAddressReader<? extends IpAddress> reader = ReaderFactory.create(address);
        return reader.getAddress();
    }

    @Override
    public String getName() {
        return this.getAddress();
    }
}

