/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import java.math.BigDecimal;

class UnitReader {
    static final BigDecimal BITS_PER_BYTE = new BigDecimal(8);
    private static final BigDecimal thousand = new BigDecimal("1000");
    private static final BigDecimal million = new BigDecimal("1000000");
    static final BigDecimal trillion = new BigDecimal("1000000000");

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$model$reader$impl$UnitReader$UnitPrefix = UnitReader.$SWITCH_TABLE$com$excentis$products$byteblower$model$reader$impl$UnitReader$UnitPrefix();
    }

    UnitReader() {
    }

    static BigDecimal convert(BigDecimal value, UnitPrefix fromUnit, UnitPrefix toUnit) {
        value = UnitReader.convertFrom(value, fromUnit);
        value = UnitReader.convertTo(value, toUnit);
        return value;
    }

    static BigDecimal convertFrom(BigDecimal value, UnitPrefix fromUnit) {
        switch (fromUnit) {
            case NANO: {
                value = value.divide(trillion);
                break;
            }
            case MICRO: {
                value = value.divide(million);
                break;
            }
            case MILLI: {
                value = value.divide(thousand);
                break;
            }
            case BASE: {
                break;
            }
            case KILO: {
                value = value.multiply(thousand);
                break;
            }
            case MEGA: {
                value = value.multiply(million);
                break;
            }
            case GIGA: {
                value = value.multiply(trillion);
                break;
            }
            default: {
                System.err.println("UnitReader::convertToBase : unsupported unit : " + (Object)((Object)fromUnit));
                return null;
            }
        }
        return value;
    }

    static BigDecimal convertTo(BigDecimal value, UnitPrefix toUnit) {
        switch (toUnit) {
            case NANO: {
                value = value.multiply(trillion);
                break;
            }
            case MICRO: {
                value = value.multiply(million);
                break;
            }
            case MILLI: {
                value = value.multiply(thousand);
                break;
            }
            case BASE: {
                break;
            }
            case KILO: {
                value = value.divide(thousand);
                break;
            }
            case MEGA: {
                value = value.divide(million);
                break;
            }
            case GIGA: {
                value = value.divide(trillion);
                break;
            }
            default: {
                System.err.println("UnitReader::convertFromBase : unsupported unit : " + (Object)((Object)toUnit));
                return null;
            }
        }
        return value;
    }

    public static enum UnitPrefix {
        NANO,
        MICRO,
        MILLI,
        BASE,
        KILO,
        MEGA,
        GIGA;

    }
}

