/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.emf.common.util.EList;

public class VlanReaderImpl
extends EByteBlowerObjectReaderImpl<Vlan>
implements VlanReader {
    public VlanReaderImpl(Vlan vlan) {
        super(vlan);
    }

    @Override
    public String getName() {
        return ((Vlan)this.getObject()).getName();
    }

    @Override
    public String getVlanId() {
        short id = ((Vlan)this.getObject()).getVlanId();
        return Short.toString(id);
    }

    @Override
    public String getPriorityCodePointString() {
        byte pcp = ((Vlan)this.getObject()).getPriorityCodePoint();
        return Utils.convertByteToString((byte)pcp);
    }

    @Override
    public String getDropEligible() {
        boolean eligible = ((Vlan)this.getObject()).isDropEligible();
        return Utils.bool2string((boolean)eligible);
    }

    @Override
    public Integer getPriorityCodePointInteger() {
        byte pcp = ((Vlan)this.getObject()).getPriorityCodePoint();
        return Utils.convertToInteger((byte)pcp);
    }

    @Override
    public VlanStack getVlanStack() {
        Vlan vlan = (Vlan)this.getObject();
        for (VlanStack stack : this.getProjectReader().getVlanStacks()) {
            VlanStackReader reader = ReaderFactory.create(stack);
            if (!reader.getVlans().contains((Object)vlan)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public boolean isOuter() {
        int nofSiblings = this.getNofSiblings();
        int index = this.getVlanIndex();
        return nofSiblings > 1 && index == 0;
    }

    @Override
    public boolean isInner() {
        int nofSiblings = this.getNofSiblings();
        int index = this.getVlanIndex();
        return nofSiblings > 1 && index == nofSiblings - 1;
    }

    @Override
    public int getVlanIndex() {
        return this.getSiblingVlans().indexOf(this.getObject());
    }

    private EList<Vlan> getSiblingVlans() {
        VlanStack stack = this.getVlanStack();
        return stack.getVlans();
    }

    @Override
    public int getNofSiblings() {
        EList<Vlan> siblings = this.getSiblingVlans();
        if (siblings != null) {
            return siblings.size();
        }
        return 0;
    }

    @Override
    public int getProtocolId() {
        return ((Vlan)this.getObject()).getProtocolId();
    }

    @Override
    public String getProtocolIdInfo() {
        switch (this.getProtocolId()) {
            case 33024: {
                return TPID_INFO[0];
            }
            case 34984: {
                return TPID_INFO[1];
            }
            case 37120: {
                return TPID_INFO[2];
            }
        }
        return "";
    }
}

