/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.reader.server.impl.EByteBlowerServerObjectReaderImpl;
import com.excentis.products.byteblower.server.model.Capability;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

abstract class PhysicalDockableReaderImpl<PhysicalDockableType extends PhysicalDockable>
extends EByteBlowerServerObjectReaderImpl<PhysicalDockableType>
implements PhysicalDockableReader<PhysicalDockableType> {
    PhysicalDockableReaderImpl(PhysicalDockableType dockable) {
        super(dockable);
    }

    @Override
    public EList<DockedByteBlowerPort> getDockedPorts() {
        return ((PhysicalDockable)this.getObject()).getDockedPorts();
    }

    @Override
    public EList<ByteBlowerGuiPortConfiguration> getAllDockedPortConfigurations() {
        UniqueEList configs = new UniqueEList();
        EList<DockedByteBlowerPort> dockedPorts = this.getAllDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            configs.add((Object)dockedPort.getDockedConfiguration());
        }
        return configs;
    }

    @Override
    public EList<ByteBlowerGuiPortConfiguration> getDockedPortConfigurations() {
        UniqueEList configs = new UniqueEList();
        EList<DockedByteBlowerPort> dockedPorts = this.getDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            configs.add((Object)dockedPort.getDockedConfiguration());
        }
        return configs;
    }

    @Override
    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortConfiguration portConfig) {
        EList<DockedByteBlowerPort> dockedPorts = this.getDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            if (dockedPort.getDockedConfiguration() != portConfig) continue;
            return dockedPort;
        }
        return null;
    }

    @Override
    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortReader reader) {
        return this.getDockedPort(reader.getByteBlowerGuiPortConfiguration());
    }

    @Override
    public List<DockedByteBlowerPortReader> getDockedPortReaders() {
        ArrayList<DockedByteBlowerPortReader> readers = new ArrayList<DockedByteBlowerPortReader>();
        EList<DockedByteBlowerPort> dockedPorts = this.getDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            readers.add(ReaderFactory.create(dockedPort));
        }
        return readers;
    }

    @Override
    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        EList<DockedByteBlowerPort> allDockedPorts = this.getAllDockedPorts();
        ArrayList<DockedByteBlowerPortReader> readers = new ArrayList<DockedByteBlowerPortReader>();
        for (DockedByteBlowerPort dockedPort : allDockedPorts) {
            readers.add(ReaderFactory.create(dockedPort));
        }
        return readers;
    }

    @Override
    public List<CapabilityReader> getCapabilities() {
        EList rawCapabilities = ((PhysicalDockable)this.getObject()).getCapabilities();
        ArrayList<CapabilityReader> result = new ArrayList<CapabilityReader>(rawCapabilities.size());
        for (Capability cap : rawCapabilities) {
            result.add(ReaderFactory.create(cap));
        }
        return result;
    }

    @Override
    public int getRemainingCapacity() {
        return -1;
    }

    @Override
    public boolean hasCapability(CapabilityReader.TYPE capability) {
        String nameToSearch = capability.name;
        for (Capability cap : ((PhysicalDockable)this.getObject()).getCapabilities()) {
            if (!nameToSearch.equals(cap.getCapName())) continue;
            return cap.getNumberValue() > 0L;
        }
        return false;
    }

    @Override
    public boolean needsRefresh() {
        return this.getServerReader().needsRefresh();
    }

    private AbstractServerReader<?> getServerReader() {
        return ReaderFactory.create(this.getServer());
    }
}

